/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.netbios;

import com.day.smb.netbios.Header;
import com.day.smb.netbios.NBException;
import com.day.smb.netbios.NBInput;
import com.day.smb.netbios.NBOutput;
import com.day.smb.netbios.NBRecord;
import com.day.smb.netbios.Name;
import com.day.smb.netbios.NameQueryRequest;
import com.day.smb.netbios.NameQueryResponse;
import com.day.smb.netbios.NodeStatusRequest;
import com.day.smb.netbios.NodeStatusResponse;
import com.day.smb.netbios.UnknownNameException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBClient {
    private static Logger log = LoggerFactory.getLogger((Class)NBClient.class);
    private static final byte[] IP4_MULTICAST_ADDRESS = new byte[]{-1, -1, -1, -1};
    private static final int NETBIOS_NS_PORT = 137;
    private static final int DEFAULT_TIMEOUT = 200;
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private DatagramSocket socket = this.createSocket();
    private int transactionID;

    protected DatagramSocket createSocket() throws NBException {
        DatagramSocket socket = null;
        boolean successful = false;
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout(200);
            successful = true;
            DatagramSocket datagramSocket = socket;
            return datagramSocket;
        }
        catch (SocketException e) {
            String msg = "Unable to create socket.";
            throw new NBException(msg, e);
        }
        finally {
            if (!successful && socket != null) {
                socket.close();
            }
        }
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    public InetAddress[] query(Name name) throws UnknownNameException, NBException {
        DatagramPacket p;
        NameQueryRequest req = new NameQueryRequest(name, ++this.transactionID);
        NBOutput out = new NBOutput(256);
        req.write(out);
        byte[] data = out.toByteArray();
        try {
            p = new DatagramPacket(data, data.length, InetAddress.getByAddress(IP4_MULTICAST_ADDRESS), 137);
            this.socket.send(p);
        }
        catch (UnknownHostException e) {
            String msg = "Unable to lookup multicast address.";
            throw new NBException(msg, e);
        }
        catch (IOException e) {
            String msg = "Error while sending datagram.";
            throw new NBException(msg, e);
        }
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        block8: while (true) {
            String msg;
            p = new DatagramPacket(new byte[512], 512);
            try {
                this.socket.receive(p);
            }
            catch (SocketTimeoutException e) {
                break;
            }
            catch (IOException e) {
                msg = "Unable to receive packet.";
                throw new NBException(msg, e);
            }
            try {
                NBInput in = new NBInput(p.getData(), p.getOffset(), p.getLength());
                Header hdr = new Header();
                hdr.read(in);
                if (hdr.getReturnCode() != 0) {
                    String msg2 = "NetBIOS rcode received: {}";
                    log.warn(msg2, (Object)Integer.toHexString(hdr.getReturnCode()));
                    continue;
                }
                NameQueryResponse res = new NameQueryResponse();
                res.read(in);
                InetAddress[] addresses = res.getAddresses();
                int i = 0;
                while (true) {
                    if (i >= addresses.length) continue block8;
                    list.add(addresses[i]);
                    ++i;
                }
            }
            catch (NBException e) {
                msg = "Unable to read name query response: {}";
                log.warn(msg, (Object)e.getMessage());
                continue;
            }
            break;
        }
        if (list.size() == 0) {
            throw new UnknownNameException(name);
        }
        InetAddress[] addresses = new InetAddress[list.size()];
        list.toArray(addresses);
        return addresses;
    }

    public NBRecord[] status(InetAddress addr) throws UnknownNameException, NBException {
        String hostname = addr.getCanonicalHostName();
        if (hostname.equals(addr.getHostAddress())) {
            String msg = "Unable to lookup fully qualified domain name.";
            throw new NBException(msg);
        }
        int sep = hostname.indexOf(46);
        if (sep != -1) {
            hostname = hostname.substring(0, sep);
        }
        return this.status(addr, new Name(hostname.toUpperCase()));
    }

    public NBRecord[] status(InetAddress addr, Name name) throws UnknownNameException, NBException {
        DatagramPacket p;
        NBOutput out = new NBOutput(256);
        NodeStatusRequest req = new NodeStatusRequest(name, ++this.transactionID);
        req.write(out);
        byte[] data = out.toByteArray();
        try {
            p = new DatagramPacket(data, data.length, addr, 137);
            this.socket.send(p);
        }
        catch (IOException e) {
            String msg = "Error while sending datagram.";
            throw new NBException(msg, e);
        }
        try {
            p = new DatagramPacket(new byte[512], 512);
            this.socket.receive(p);
        }
        catch (SocketTimeoutException e) {
            throw new UnknownNameException(name);
        }
        catch (IOException e) {
            String msg = "Error while receiving data.";
            throw new NBException(msg, e);
        }
        NBInput in = new NBInput(p.getData(), p.getOffset(), p.getLength());
        Header hdr = new Header();
        hdr.read(in);
        if (hdr.getReturnCode() != 0) {
            String msg = "NetBIOS rcode received: " + hdr.getReturnCode();
            throw new NBException(msg);
        }
        NodeStatusResponse res = new NodeStatusResponse();
        res.read(in);
        return res.getRecords();
    }

    public static void main(String[] args) throws Exception {
        log.error("hallo");
        NBClient client = new NBClient();
        NBRecord[] records = client.status(InetAddress.getByName(args[0]));
        for (int i = 0; i < records.length; ++i) {
            NBRecord record = records[i];
            System.out.println(record.getName() + " " + Integer.toHexString(record.getFlags()));
        }
    }
}

