/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.netbios;

import com.day.smb.netbios.NBException;

public class NBInput {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private final byte[] data;
    private int position;

    public NBInput(byte[] data) {
        this.data = data;
    }

    public NBInput(byte[] data, int off, int len) {
        this.data = new byte[len];
        System.arraycopy(data, off, this.data, 0, len);
    }

    public int readUnsignedByte() throws NBException {
        this.checkAvailable(1);
        return this.data[this.position++] & 0xFF;
    }

    public int readUnsignedShort() throws NBException {
        this.checkAvailable(2);
        int ch1 = this.data[this.position++] & 0xFF;
        int ch2 = this.data[this.position++] & 0xFF;
        return (ch1 << 8) + (ch2 << 0);
    }

    public int readInt() throws NBException {
        this.checkAvailable(4);
        int ch1 = this.data[this.position++] & 0xFF;
        int ch2 = this.data[this.position++] & 0xFF;
        int ch3 = this.data[this.position++] & 0xFF;
        int ch4 = this.data[this.position++] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public byte[] readFully(int len) throws NBException {
        this.checkAvailable(len);
        byte[] buf = new byte[len];
        System.arraycopy(this.data, this.position, buf, 0, len);
        this.position += len;
        return buf;
    }

    private void checkAvailable(int n) throws NBException {
        if (this.position + n > this.data.length) {
            String msg = "Not enough data available. Bytes expected: " + n + ", got: " + (this.data.length - this.position);
            throw new NBException(msg);
        }
    }
}

