/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.netbios;

public class NBOutput {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private byte[] data;
    private int position;

    public NBOutput(int initialCapacity) {
        this.data = new byte[initialCapacity];
    }

    public NBOutput() {
        this(512);
    }

    public void writeByte(int n) {
        this.write(n);
    }

    public void writeShort(int s) {
        this.write(s >>> 8 & 0xFF);
        this.write(s >>> 0 & 0xFF);
    }

    public void writeInt(int n) {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public void write(int n) {
        this.ensureCapacity(1);
        this.data[this.position++] = (byte)(n & 0xFF);
    }

    public void write(byte[] buf) {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) {
        this.ensureCapacity(len);
        System.arraycopy(buf, off, this.data, this.position, len);
        this.position += len;
    }

    public byte[] toByteArray() {
        byte[] b = new byte[this.position];
        System.arraycopy(this.data, 0, b, 0, b.length);
        return b;
    }

    private void ensureCapacity(int n) {
        if (this.position + n > this.data.length) {
            if (n < 512) {
                n = 512;
            }
            byte[] tmp = new byte[this.data.length + n];
            System.arraycopy(this.data, 0, tmp, 0, this.position);
            this.data = tmp;
        }
    }
}

