/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.netbios;

import com.day.smb.netbios.NBException;
import com.day.smb.netbios.NBInput;
import com.day.smb.netbios.NBOutput;

public class Name {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    public static final Name BROWSER_GROUP = new Name("\u0001\u0002__MSBROWSE__\u0002", 1);
    public static final Name ASTERISK = new Name("*");
    private static final int PLAIN_LENGTH = 16;
    private static final int ENCODED_LENGTH = 32;
    private String s;
    private int suffix;

    public Name(String s, int suffix) {
        this.s = s;
        this.suffix = suffix;
    }

    public Name(String s) {
        this(s, 0);
    }

    protected Name() {
    }

    public void readEncoded(NBInput in) throws NBException {
        int len = in.readUnsignedByte();
        if (len != 32) {
            String msg = "Name length must be 32, got " + len;
            throw new NBException(msg);
        }
        this.decode(in.readFully(32));
        in.readUnsignedByte();
    }

    public void read(NBInput in) throws NBException {
        byte[] data = in.readFully(16);
        this.suffix = data[15];
        this.s = new String(data, 0, 15).trim();
    }

    public void writeEncoded(NBOutput out) throws NBException {
        out.writeByte(32);
        out.write(this.encode());
    }

    private final byte[] encode() {
        byte[] result = new byte[33];
        char[] ac = this.s.toCharArray();
        for (int i = 0; i < 15; ++i) {
            if (i < ac.length) {
                char c = ac[i];
                result[i * 2] = (byte)(65 + ((c & 0xF0) >> 4));
                result[i * 2 + 1] = (byte)(65 + (c & 0xF));
                continue;
            }
            result[i * 2] = 67;
            result[i * 2 + 1] = 65;
        }
        result[30] = (byte)(65 + ((this.suffix & 0xF0) >> 4));
        result[31] = (byte)(65 + (this.suffix & 0xF));
        return result;
    }

    private void decode(byte[] b) {
        int n2;
        int n1;
        int n;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length - 2 && (n = (n1 = b[i] & 0xFF) - 65 << 4 | (n2 = b[i + 1] & 0xFF) - 65) != 32; i += 2) {
            buf.append((char)n);
        }
        this.s = buf.toString();
        n1 = b[b.length - 2] & 0xFF;
        n2 = b[b.length - 2 + 1] & 0xFF;
        this.suffix = n1 - 65 << 4 | n2 - 65;
    }

    public String getName() {
        return this.s;
    }

    public int getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.s + "<" + Integer.toHexString(this.suffix) + ">";
    }
}

