/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.netbios;

import com.day.smb.netbios.NBException;
import com.day.smb.netbios.NBInput;
import com.day.smb.netbios.Name;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameQueryResponse {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static Logger log = LoggerFactory.getLogger((Class)NameQueryResponse.class);
    private static final int RD_LENGTH = 6;
    private Name name;
    private int ttl;
    private InetAddress[] addresses;

    public void read(NBInput in) throws NBException {
        this.name = new Name();
        this.name.readEncoded(in);
        in.readUnsignedShort();
        in.readUnsignedShort();
        this.ttl = in.readInt();
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        for (int rdlen = in.readUnsignedShort(); rdlen > 0; rdlen -= 6) {
            in.readUnsignedShort();
            try {
                list.add(InetAddress.getByAddress(in.readFully(4)));
                continue;
            }
            catch (UnknownHostException e) {
                String msg = "Unable to convert IP address: {}";
                log.warn(msg, (Object)e.getMessage());
            }
        }
        this.addresses = new InetAddress[list.size()];
        list.toArray(this.addresses);
    }

    public InetAddress[] getAddresses() {
        return this.addresses;
    }
}

