/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.netbios;

import com.day.smb.Util;
import com.day.smb.netbios.Header;
import com.day.smb.netbios.NBException;
import com.day.smb.netbios.NBInput;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class NameService {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private InetSocketAddress address;
    private DatagramSocket socket;

    public NameService(InetSocketAddress address) {
        this.address = address;
    }

    public NameService() {
        this(null);
    }

    public void start() throws SocketException {
        this.socket = this.createSocket();
        Runnable listener = new Runnable(){

            public void run() {
                NameService.this.doRun();
            }
        };
        Thread t = new Thread(listener, "Name Service");
        t.start();
    }

    private DatagramSocket createSocket() throws SocketException {
        if (this.address != null) {
            return new DatagramSocket(this.address);
        }
        return new DatagramSocket();
    }

    protected void doRun() {
        while (true) {
            try {
                while (true) {
                    DatagramPacket p = new DatagramPacket(new byte[512], 512);
                    this.socket.receive(p);
                    NBInput in = new NBInput(p.getData(), p.getOffset(), p.getLength());
                    Header hdr = new Header();
                    hdr.read(in);
                    Util.print(p.getData(), p.getOffset(), p.getLength());
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                continue;
            }
            catch (NBException e) {
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        InetAddress addr = InetAddress.getByName(args[0]);
        int port = Integer.parseInt(args[1]);
        NameService ns = new NameService(new InetSocketAddress(addr, port));
        ns.start();
    }
}

