/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.ntlm;

import java.io.ByteArrayOutputStream;

public class Base64 {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final char[] BASE64CHARS;
    private static final byte[] DECODETABLE;
    private static final char BASE64PAD = '=';

    private Base64() {
    }

    public static String encode(byte[] data) {
        int i;
        int len;
        StringBuffer result = new StringBuffer();
        int off = 0;
        char[] enc = new char[4];
        for (len = data.length; len >= 3; len -= 3) {
            i = ((data[off] & 0xFF) << 16) + ((data[off + 1] & 0xFF) << 8) + (data[off + 2] & 0xFF);
            enc[0] = BASE64CHARS[i >> 18];
            enc[1] = BASE64CHARS[i >> 12 & 0x3F];
            enc[2] = BASE64CHARS[i >> 6 & 0x3F];
            enc[3] = BASE64CHARS[i & 0x3F];
            result.append(enc, 0, 4);
            off += 3;
        }
        if (len == 1) {
            i = data[off] & 0xFF;
            enc[0] = BASE64CHARS[i >> 2];
            enc[1] = BASE64CHARS[i << 4 & 0x3F];
            enc[2] = 61;
            enc[3] = 61;
            result.append(enc, 0, 4);
        } else if (len == 2) {
            i = ((data[off] & 0xFF) << 8) + (data[off + 1] & 0xFF);
            enc[0] = BASE64CHARS[i >> 10];
            enc[1] = BASE64CHARS[i >> 4 & 0x3F];
            enc[2] = BASE64CHARS[i << 2 & 0x3F];
            enc[3] = 61;
            result.append(enc, 0, 4);
        }
        return result.toString();
    }

    public static byte[] decode(String s) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        char[] chars = s.toCharArray();
        char[] chunk = new char[4];
        byte[] dec = new byte[3];
        int posChunk = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < DECODETABLE.length && DECODETABLE[c] != 127 || c == '=') {
                chunk[posChunk++] = c;
                if (posChunk != chunk.length) continue;
                byte b0 = DECODETABLE[chunk[0]];
                byte b1 = DECODETABLE[chunk[1]];
                byte b2 = DECODETABLE[chunk[2]];
                byte b3 = DECODETABLE[chunk[3]];
                if (chunk[3] == '=' && chunk[2] == '=') {
                    dec[0] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                    result.write(dec, 0, 1);
                } else if (chunk[3] == '=') {
                    dec[0] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                    dec[1] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                    result.write(dec, 0, 2);
                } else {
                    dec[0] = (byte)(b0 << 2 & 0xFC | b1 >> 4 & 3);
                    dec[1] = (byte)(b1 << 4 & 0xF0 | b2 >> 2 & 0xF);
                    dec[2] = (byte)(b2 << 6 & 0xC0 | b3 & 0x3F);
                    result.write(dec, 0, 3);
                }
                posChunk = 0;
                continue;
            }
            throw new IllegalArgumentException("specified data is not base64 encoded");
        }
        return result.toByteArray();
    }

    static {
        int i;
        BASE64CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        DECODETABLE = new byte[128];
        for (i = 0; i < DECODETABLE.length; ++i) {
            Base64.DECODETABLE[i] = 127;
        }
        for (i = 0; i < BASE64CHARS.length; ++i) {
            Base64.DECODETABLE[Base64.BASE64CHARS[i]] = (byte)i;
        }
    }
}

