/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.ntlm;

import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.Util;
import java.util.Arrays;

public class Header {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    public static final int TYPE_1 = 1;
    public static final int TYPE_2 = 2;
    public static final int TYPE_3 = 3;
    public static final int SIZE = 12;
    private static final byte[] SIGNATURE = new byte[]{78, 84, 76, 77, 83, 83, 80, 0};
    private int type;

    public void read(SmbInput input) throws SmbException {
        byte[] signature = input.readFully(SIGNATURE.length);
        if (!Arrays.equals(signature, SIGNATURE)) {
            String msg = "Expected signature: " + Util.toHexString(SIGNATURE) + ", received: " + Util.toHexString(signature);
            throw new SmbException(msg);
        }
        this.type = input.readInt();
        if (this.type < 1 || this.type > 3) {
            String msg = "Unexpected message type: " + this.type;
            throw new SmbException(msg);
        }
    }

    public void write(SmbOutput output) {
        output.write(SIGNATURE);
        output.writeInt(this.type);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type < 1 || type > 3) {
            String msg = "Illegal message type: " + type;
            throw new IllegalArgumentException(msg);
        }
        this.type = type;
    }
}

