/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.ntlm;

import com.day.smb.ntlm.NTLM;
import java.security.Principal;
import java.util.Arrays;

public class NTLMPrincipal
implements Principal {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private String username;
    private String workstation;
    private String domain;
    private byte[] challenge;
    private byte[] response;

    public NTLMPrincipal(String username, String workstation, String domain, byte[] challenge, byte[] response) {
        this.username = username;
        this.workstation = workstation;
        this.domain = domain;
        this.challenge = challenge;
        this.response = response;
    }

    protected NTLMPrincipal() {
    }

    public boolean checkPassword(byte[] ntlmHash) throws Exception {
        byte[] response = NTLM.lmResponse(ntlmHash, this.getChallenge());
        return Arrays.equals(response, this.getResponse());
    }

    public String getUsername() {
        return this.username;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public String getDomain() {
        return this.domain;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public String getName() {
        return this.getUsername();
    }
}

