/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.ntlm;

import com.day.smb.ntlm.NTLMPrincipal;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTLMPrincipalHolder
extends NTLMPrincipal {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static Logger log = LoggerFactory.getLogger((Class)NTLMPrincipalHolder.class);
    private Object principal;

    public static boolean isNTLMPrincipal(Object o) {
        if (o != null) {
            String className = o.getClass().getName();
            return className.equals(NTLMPrincipal.class.getName());
        }
        return false;
    }

    public static NTLMPrincipal create(Object principal) throws IllegalArgumentException {
        if (!NTLMPrincipalHolder.isNTLMPrincipal(principal)) {
            String msg = "Not an NTLMPrincipal.";
            throw new IllegalArgumentException(msg);
        }
        return new NTLMPrincipalHolder(principal);
    }

    protected NTLMPrincipalHolder(Object principal) {
        this.principal = principal;
    }

    public String getUsername() {
        return (String)this.invoke("getUsername");
    }

    public String getWorkstation() {
        return (String)this.invoke("getWorkstation");
    }

    public String getDomain() {
        return (String)this.invoke("getDomain");
    }

    public byte[] getChallenge() {
        return (byte[])this.invoke("getChallenge");
    }

    public byte[] getResponse() {
        return (byte[])this.invoke("getResponse");
    }

    private Object invoke(String name) {
        try {
            Method m = this.principal.getClass().getMethod(name, new Class[0]);
            return m.invoke(this.principal, new Object[0]);
        }
        catch (Exception e) {
            log.error("Unable to invoke {}: {}", (Object)name, (Object)e.getMessage());
            return null;
        }
    }
}

