/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.ntlm;

import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.Util;
import com.day.smb.ntlm.Header;
import com.day.smb.ntlm.Message;
import java.io.UnsupportedEncodingException;

public class Type2Message
extends Message {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final int MINIMAL_SIZE = 56;
    private static final int NONE = 0;
    private static final int SERVER = 1;
    private static final int DOMAIN = 2;
    private static final int FQDNSHOST = 3;
    private static final int DNSDOMAIN = 4;
    private static final int PARENTDOMAIN = 5;
    private String targetName;
    private int flags;
    private byte[] challenge;
    private byte[] context;
    private byte[] targetInfo;
    private String server;
    private String domain;
    private String fqDnsHost;
    private String dnsDomain;
    private String parentDomain;

    public void read(SmbInput input) throws SmbException {
        byte[] buf = this.readSecurityBuffer(input);
        this.flags = input.readInt();
        if ((this.flags & 1) != 0) {
            try {
                this.targetName = new String(buf, "UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new SmbException("Unable to convert bytes to unicode.");
            }
        } else {
            this.targetName = new String(buf);
        }
        this.challenge = input.readFully(8);
        this.context = input.readFully(8);
        if ((this.flags & 0x800000) != 0) {
            try {
                this.targetInfo = this.readSecurityBuffer(input);
                this.processTargetInfo(new SmbInput(this.targetInfo));
            }
            catch (UnsupportedEncodingException e) {
                throw new SmbException("Unable to convert bytes to unicode.");
            }
        }
    }

    public void write(SmbOutput output) throws SmbException {
        byte[] data;
        byte[] targetNameData;
        Header hdr = new Header();
        hdr.setType(2);
        hdr.write(output);
        try {
            targetNameData = this.targetName.getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            throw new SmbException("Unable to convert bytes to unicode.");
        }
        output.writeShort(targetNameData.length);
        output.writeShort(targetNameData.length);
        output.writeInt(56);
        output.writeInt(this.flags);
        output.write(this.challenge);
        output.write(this.context);
        SmbOutput targetInfoOut = new SmbOutput();
        if (this.domain != null) {
            try {
                data = this.domain.getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new SmbException("Unable to convert bytes to unicode.");
            }
            targetInfoOut.writeShort(2);
            targetInfoOut.writeShort(data.length);
            targetInfoOut.write(data);
        }
        if (this.server != null) {
            try {
                data = this.server.getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new SmbException("Unable to convert bytes to unicode.");
            }
            targetInfoOut.writeShort(1);
            targetInfoOut.writeShort(data.length);
            targetInfoOut.write(data);
        }
        if (this.dnsDomain != null) {
            try {
                data = this.dnsDomain.getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new SmbException("Unable to convert bytes to unicode.");
            }
            targetInfoOut.writeShort(4);
            targetInfoOut.writeShort(data.length);
            targetInfoOut.write(data);
        }
        if (this.fqDnsHost != null) {
            try {
                data = this.fqDnsHost.getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new SmbException("Unable to convert bytes to unicode.");
            }
            targetInfoOut.writeShort(3);
            targetInfoOut.writeShort(data.length);
            targetInfoOut.write(data);
        }
        if (this.parentDomain != null) {
            try {
                data = this.parentDomain.getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new SmbException("Unable to convert bytes to unicode.");
            }
            targetInfoOut.writeShort(5);
            targetInfoOut.writeShort(data.length);
            targetInfoOut.write(data);
        }
        targetInfoOut.writeShort(0);
        targetInfoOut.writeShort(0);
        byte[] targetInfo = targetInfoOut.toByteArray();
        output.writeShort(targetInfo.length);
        output.writeShort(targetInfo.length);
        output.writeInt(56 + targetNameData.length);
        output.write(new byte[]{5, 2, -50, 14, 0, 0, 0, 15});
        output.write(targetNameData);
        output.append(targetInfoOut);
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public byte[] getContext() {
        return this.context;
    }

    public void setContext(byte[] context) {
        this.context = context;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public void setChallenge(byte[] challenge) {
        this.challenge = challenge;
    }

    public byte[] getTargetInfo() {
        return this.targetInfo;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getFqDnsHost() {
        return this.fqDnsHost;
    }

    public void setFqDnsHost(String fqDnsHost) {
        this.fqDnsHost = fqDnsHost;
    }

    public String getDnsDomain() {
        return this.dnsDomain;
    }

    public void setDnsDomain(String dnsDomain) {
        this.dnsDomain = dnsDomain;
    }

    public String getParentDomain() {
        return this.parentDomain;
    }

    public void setParentDomain(String parentDomain) {
        this.parentDomain = parentDomain;
    }

    private void processTargetInfo(SmbInput input) throws SmbException, UnsupportedEncodingException {
        while (true) {
            int type = input.readUnsignedShort();
            int length = input.readUnsignedShort();
            byte[] content = input.readFully(length);
            switch (type) {
                case 0: {
                    return;
                }
                case 1: {
                    this.server = new String(content, "UnicodeLittleUnmarked");
                    break;
                }
                case 2: {
                    this.domain = new String(content, "UnicodeLittleUnmarked");
                    break;
                }
                case 3: {
                    this.fqDnsHost = new String(content, "UnicodeLittleUnmarked");
                    break;
                }
                case 4: {
                    this.dnsDomain = new String(content, "UnicodeLittleUnmarked");
                    break;
                }
                case 5: {
                    this.parentDomain = new String(content, "UnicodeLittleUnmarked");
                    break;
                }
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append(" {\n  targetName=");
        buf.append(this.targetName);
        buf.append("\n  flags=");
        buf.append(Integer.toHexString(this.flags));
        buf.append("\n  challenge=");
        buf.append(Util.toHexString(this.challenge));
        buf.append("\n  context=");
        buf.append(Util.toHexString(this.context));
        buf.append("\n  server=");
        buf.append(this.server);
        buf.append("\n  domain=");
        buf.append(this.domain);
        buf.append("\n  fqDnsHost=");
        buf.append(this.fqDnsHost);
        buf.append("\n  dnsDomain=");
        buf.append(this.dnsDomain);
        buf.append("\n  parentDomain=");
        buf.append(this.parentDomain);
        buf.append("\n}");
        return buf.toString();
    }
}

