/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.ntlm;

import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.Util;
import com.day.smb.ntlm.Message;
import java.io.UnsupportedEncodingException;

public class Type3Message
extends Message {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private boolean unicode;
    private byte[] lmResponse;
    private byte[] ntlmResponse;
    private String targetName;
    private String userName;
    private String workstation;
    private byte[] sessionKey;

    public Type3Message(boolean unicode) {
        this.unicode = unicode;
    }

    public void read(SmbInput input) throws SmbException {
        this.lmResponse = this.readSecurityBuffer(input);
        this.ntlmResponse = this.readSecurityBuffer(input);
        byte[] buf = this.readSecurityBuffer(input);
        if (this.unicode) {
            try {
                this.targetName = new String(buf, "UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new SmbException("Unable to convert bytes to unicode.");
            }
        } else {
            this.targetName = new String(buf);
        }
        buf = this.readSecurityBuffer(input);
        if (this.unicode) {
            try {
                this.userName = new String(buf, "UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new SmbException("Unable to convert bytes to unicode.");
            }
        } else {
            this.userName = new String(buf);
        }
        buf = this.readSecurityBuffer(input);
        if (this.unicode) {
            try {
                this.workstation = new String(buf, "UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new SmbException("Unable to convert bytes to unicode.");
            }
        } else {
            this.workstation = new String(buf);
        }
        this.sessionKey = this.readSecurityBuffer(input);
    }

    public byte[] getLmResponse() {
        return this.lmResponse;
    }

    public byte[] getNtlmResponse() {
        return this.ntlmResponse;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append(" {\n  lmResponse=");
        buf.append(Util.toHexString(this.lmResponse));
        buf.append("\n  ntlmResponse=");
        buf.append(Util.toHexString(this.ntlmResponse));
        buf.append("\n  targetName=");
        buf.append(this.targetName);
        buf.append("\n  userName=");
        buf.append(this.userName);
        buf.append("\n  workstation=");
        buf.append(this.workstation);
        buf.append("\n  sessionkey=");
        buf.append(Util.toHexString(this.sessionKey));
        buf.append("\n}");
        return buf.toString();
    }
}

