/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidParameterException;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;

class EchoHandler
extends SmbCommandHandler {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    EchoHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        int echoCount = paramsIn.readUnsignedShort();
        SmbInput dataIn = request.getData();
        int byteCount = dataIn.available();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("ECHO[echoCount=" + echoCount + ",byteCount=" + byteCount + "]");
        }
        if (echoCount != 1) {
            String msg = "ECHO: unexpected echo count: " + echoCount;
            throw new InvalidParameterException(msg);
        }
        byte[] data = new byte[byteCount];
        dataIn.readFully(data);
        SmbOutput paramsOut = response.getParameters();
        paramsOut.writeShort(0);
        SmbOutput dataOut = response.getData();
        dataOut.write(data);
    }
}

