/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidParameterException;
import com.day.smb.SmbDate;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.SmbTime;
import com.day.smb.SystemTime;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbFile;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;
import java.io.UnsupportedEncodingException;
import java.util.Date;

class FindFirst2Handler
extends SmbCommandHandler {
    private static final int INFO_STANDARD = 1;
    private static final int INFO_QUERY_EA_SIZE = 2;
    private static final int FIND_FILE_DIRECTORY_INFO = 257;
    private static final int FIND_FILE_BOTH_DIRECTORY_INFO = 260;
    private static final int DEFAULT_ALLOCATION_SIZE = 4096;
    private static final int FIND_FILE_DIRECTORY_INFO_SIZE = 64;
    private static final int FIND_FILE_BOTH_DIRECTORY_INFO_SIZE = 94;
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    FindFirst2Handler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        int searchAttributes = paramsIn.readUnsignedShort();
        int searchCount = paramsIn.readUnsignedShort();
        int flags = paramsIn.readUnsignedShort();
        int informationLevel = paramsIn.readUnsignedShort();
        int searchStorageType = paramsIn.readInt();
        String pattern = paramsIn.readString();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("FIND_FIRST2[searchAttributes=" + searchAttributes + ",searchCount=" + searchCount + ",flags=" + flags + ",informationLevel=" + informationLevel + ",searchStorageType=" + searchStorageType + ",pattern=" + pattern + "]");
        }
        SmbOutput paramsOut = response.getParameters();
        SmbOutput dataOut = response.getData();
        SmbFile[] files = request.getTree().list(pattern);
        if (files.length == 0) {
            response.setStatus(-1073741809);
            return;
        }
        paramsOut.writeShort(0);
        paramsOut.writeShort(files.length);
        paramsOut.writeShort(1);
        paramsOut.writeShort(0);
        paramsOut.writeShort(0);
        for (int i = 0; i < files.length; ++i) {
            this.writeInfo(files[i], informationLevel, i + 1, dataOut, request.isUnicode());
        }
    }

    private void writeInfo(SmbFile file, int level, int index, SmbOutput out, boolean unicode) throws SmbException {
        byte[] filename = FindFirst2Handler.getBytes(file.getName(), unicode);
        switch (level) {
            case 1: {
                out.writeInt(0);
                long createdTime = file.getCreatedTime();
                long lastAccessTime = file.getLastAccessTime();
                long lastWriteTime = file.getLastWriteTime();
                out.writeShort(new SmbDate(createdTime).toShort());
                out.writeShort(new SmbTime(createdTime).toShort());
                out.writeShort(new SmbDate(lastAccessTime).toShort());
                out.writeShort(new SmbTime(lastAccessTime).toShort());
                out.writeShort(new SmbDate(lastWriteTime).toShort());
                out.writeShort(new SmbTime(lastWriteTime).toShort());
                out.writeInt((int)file.getDataSize());
                out.writeInt(4096);
                out.writeShort(file.getAttributes());
                out.writeByte(filename.length);
                out.write(filename);
                break;
            }
            case 2: {
                out.writeInt(0);
                long createdTime = file.getCreatedTime();
                long lastAccessTime = file.getLastAccessTime();
                long lastWriteTime = file.getLastWriteTime();
                out.writeShort(new SmbDate(createdTime).toShort());
                out.writeShort(new SmbTime(createdTime).toShort());
                out.writeShort(new SmbDate(lastAccessTime).toShort());
                out.writeShort(new SmbTime(lastAccessTime).toShort());
                out.writeShort(new SmbDate(lastWriteTime).toShort());
                out.writeShort(new SmbTime(lastWriteTime).toShort());
                out.writeInt((int)file.getDataSize());
                out.writeInt(4096);
                out.writeShort(file.getAttributes());
                out.writeInt(0);
                out.writeByte(filename.length);
                out.write(filename);
                break;
            }
            case 257: {
                out.writeInt(64 + filename.length);
                out.writeInt(index);
                out.writeLong(file.getCreatedSystemTime().toLong());
                out.writeLong(file.getLastAccessSystemTime().toLong());
                out.writeLong(file.getLastWriteSystemTime().toLong());
                out.writeLong(file.getLastWriteSystemTime().toLong());
                out.writeLong(file.getDataSize());
                out.writeLong(4096L);
                out.writeInt(file.getAttributes());
                out.writeInt(filename.length);
                out.write(filename);
                break;
            }
            case 260: {
                out.writeInt(94 + filename.length);
                out.writeInt(index);
                SystemTime st = new SystemTime(new Date(file.getLastWriteTime()));
                out.writeLong(st.toLong());
                out.writeLong(st.toLong());
                out.writeLong(st.toLong());
                out.writeLong(st.toLong());
                out.writeLong(file.getDataSize());
                out.writeLong(4096L);
                out.writeInt(file.getAttributes());
                out.writeInt(filename.length);
                out.writeInt(0);
                out.writeByte(0);
                out.writeByte(0);
                out.write(new byte[24]);
                out.write(filename);
                break;
            }
            default: {
                String msg = "FIND_FIRST2: information level unknown: 0x" + Integer.toHexString(level);
                throw new InvalidParameterException(msg);
            }
        }
    }

    private static byte[] getBytes(String s, boolean unicode) throws SmbException {
        String charset = unicode ? "UnicodeLittleUnmarked" : "ASCII";
        try {
            return s.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unable to encode " + charset + " string.";
            throw new SmbException(msg, e);
        }
    }
}

