/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidParameterException;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.SystemTime;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;
import java.util.TimeZone;

class NegotiateHandler
extends SmbCommandHandler {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final int MAX_MPX_COUNT = 50;
    private static final int MAX_NUMBER_VCS = 1;
    private static final int MAX_BUFFER_SIZE = 33028;
    private static final int MAX_RAW_SIZE = 65536;

    NegotiateHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        int dialectIndex = 0;
        SmbInput buffer = request.getData();
        while (!buffer.isEOF()) {
            int format = buffer.readUnsignedByte();
            if (format != 2) {
                String msg = "Unexpected format identifier: " + format;
                throw new InvalidParameterException(msg);
            }
            String dialect = buffer.readASCII();
            if (cmdLog.isDebugEnabled()) {
                cmdLog.debug("NEGOTIATE[dialect=" + dialect + "]");
            }
            if (dialect.equals("NT LM 0.12")) {
                SmbOutput out = response.getParameters();
                out.writeShort(dialectIndex);
                out.writeByte(0);
                out.writeShort(50);
                out.writeShort(1);
                out.writeInt(33028);
                out.writeInt(65536);
                out.writeInt(0);
                out.writeInt(5085);
                out.writeLong(new SystemTime().toLong());
                out.writeShort(NegotiateHandler.getTimezoneOffset());
                out.writeByte(0);
                out = response.getData();
                out.writeString(request.getServer().getPrimaryDomain());
                return;
            }
            ++dialectIndex;
        }
        response.getParameters().writeShort(-1);
    }

    private static int getTimezoneOffset() {
        return -(TimeZone.getDefault().getRawOffset() / 60000);
    }
}

