/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidParameterException;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbFile;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;

class NtCreateAndXHandler
extends SmbCommandHandler {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final int DEFAULT_ALLOCATION_SIZE = 4096;
    private static final String DATA_STREAM = ":$DATA";

    NtCreateAndXHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        paramsIn.readUnsignedByte();
        int nameLength = paramsIn.readUnsignedShort();
        int flags = paramsIn.readInt();
        int rootDirectoryFid = paramsIn.readInt();
        int desiredAccess = paramsIn.readInt();
        long allocationSize = paramsIn.readLong();
        int extFileAttributes = paramsIn.readInt();
        int shareAccess = paramsIn.readInt();
        int createDisposition = paramsIn.readInt();
        int createOptions = paramsIn.readInt();
        int impersonationLevel = paramsIn.readInt();
        int securityFlags = paramsIn.readUnsignedByte();
        SmbInput bufferIn = request.getData();
        String filename = bufferIn.readString();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("NT_CREATE_ANDX[flags=" + flags + ",rootDirectoryFid=" + rootDirectoryFid + ",desiredAccess=" + desiredAccess + ",allocationSize=" + allocationSize + ",extFileAttributes=" + extFileAttributes + ",shareAccess=" + shareAccess + ",createDisposition=" + createDisposition + ",createOptions=" + createOptions + ",impersonationLevel=" + impersonationLevel + ",securityFlags=" + securityFlags + ",filename=" + filename + "]");
        }
        if (filename.endsWith(DATA_STREAM)) {
            response.setStatus(-1073741809);
            return;
        }
        SmbFile file = request.getTree().open(filename, NtCreateAndXHandler.toOpenFunction(createDisposition), (createOptions & 1) != 0);
        SmbOutput paramsOut = response.getParameters();
        paramsOut.writeByte((flags & 4) != 0 ? 2 : 0);
        paramsOut.writeShort(file.getFid());
        paramsOut.writeInt(file.getOpenAction());
        paramsOut.writeLong(file.getCreatedSystemTime().toLong());
        paramsOut.writeLong(file.getLastAccessSystemTime().toLong());
        paramsOut.writeLong(file.getLastWriteSystemTime().toLong());
        paramsOut.writeLong(file.getLastWriteSystemTime().toLong());
        paramsOut.writeInt(file.getAttributes());
        paramsOut.writeLong(4096L);
        paramsOut.writeLong(file.getDataSize());
        paramsOut.writeShort(0);
        paramsOut.writeShort(0);
        paramsOut.writeBoolean(file.isDirectory());
    }

    private static int toOpenFunction(int createDisposition) throws SmbException {
        switch (createDisposition) {
            case 1: {
                return 1;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return 17;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 18;
            }
        }
        String msg = "CreateDisposition unknown : " + createDisposition;
        throw new InvalidParameterException(msg);
    }
}

