/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidParameterException;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;
import com.day.smb.server.UnknownCommandHandler;

class NtTransactHandler
extends SmbCommandHandler {
    private static final int IOCTL = 2;
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final int PARAMETER_OFFSET = 71;
    private static final SmbCommandHandler UNKNOWN = new UnknownCommandHandler("NT_TRANSACT_");

    NtTransactHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        int maxSetupCount = paramsIn.readUnsignedByte();
        paramsIn.readUnsignedShort();
        int totalParameterCount = paramsIn.readInt();
        int totalDataCount = paramsIn.readInt();
        int maxParameterCount = paramsIn.readInt();
        int maxDataCount = paramsIn.readInt();
        int parameterCount = paramsIn.readInt();
        int parameterOffset = paramsIn.readInt();
        int dataCount = paramsIn.readInt();
        int dataOffset = paramsIn.readInt();
        int setupCount = paramsIn.readUnsignedByte();
        int function = paramsIn.readUnsignedShort();
        byte[] buf = new byte[setupCount * 2];
        paramsIn.readFully(buf);
        SmbInput setup = new SmbInput(buf, request.isUnicode());
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("NT_TRANSACT[function=" + function + "]");
        }
        SmbInput subParamsIn = request.getInput(parameterOffset, parameterCount);
        SmbInput subDataIn = request.getInput(dataOffset, dataCount);
        SmbRequest innerRequest = new SmbRequest(request, function, subParamsIn, subDataIn);
        SmbResponse innerResponse = new SmbResponse(response);
        switch (function) {
            case 2: {
                this.handleIOCtl(setup, innerRequest, innerResponse, maxDataCount);
                break;
            }
            default: {
                UNKNOWN.handle(innerRequest, innerResponse);
            }
        }
        if (response.getStatus() == 0) {
            SmbOutput subParamsOut = innerResponse.getParameters();
            SmbOutput subDataOut = innerResponse.getData();
            SmbOutput dataOut = response.getData();
            dataOut.align(4);
            int paramOutOffset = 71 + dataOut.getLength();
            dataOut.append(subParamsOut);
            dataOut.align(2);
            int dataOutOffset = 71 + dataOut.getLength();
            dataOut.append(subDataOut);
            SmbOutput paramsOut = response.getParameters();
            paramsOut.write(new byte[3]);
            paramsOut.writeInt(subParamsOut.getLength());
            paramsOut.writeInt(subDataOut.getLength());
            paramsOut.writeInt(subParamsOut.getLength());
            paramsOut.writeInt(paramOutOffset);
            paramsOut.writeInt(0);
            paramsOut.writeInt(subDataOut.getLength());
            paramsOut.writeInt(dataOutOffset);
            paramsOut.writeInt(0);
            paramsOut.writeByte(0);
        }
    }

    private void handleIOCtl(SmbInput setup, SmbRequest request, SmbResponse response, int maxDataCount) throws SmbException {
        int functionCode = setup.readInt();
        int fid = setup.readUnsignedShort();
        boolean isFsctl = setup.readBoolean();
        int isFlags = setup.readUnsignedByte();
        switch (functionCode) {
            case 1327204: {
                String[] versions = new String[]{"@GMT-2007.03.16-07.00.22"};
                int dataLen = (versions[0].length() + 1) * 2;
                SmbOutput dataOut = response.getData();
                if (maxDataCount < dataLen + 16) {
                    dataOut.writeInt(versions.length);
                    dataOut.writeInt(0);
                    dataOut.writeInt(dataLen);
                    dataOut.writeInt(0);
                    break;
                }
                dataOut.writeInt(versions.length);
                dataOut.writeInt(versions.length);
                dataOut.writeInt(dataLen);
                for (int i = 0; i < versions.length; ++i) {
                    dataOut.writeUnicode(versions[i]);
                }
                break;
            }
            default: {
                String msg = "Function code unknown: " + functionCode;
                throw new InvalidParameterException(msg);
            }
        }
    }
}

