/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbFile;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;

class OpenAndXHandler
extends SmbCommandHandler {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    OpenAndXHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        int flags = paramsIn.readUnsignedShort();
        int desiredAccess = paramsIn.readUnsignedShort();
        int searchAttributes = paramsIn.readUnsignedShort();
        int fileAttributes = paramsIn.readUnsignedShort();
        int creationTime = paramsIn.readInt();
        int openFunction = paramsIn.readUnsignedShort();
        int allocationSize = paramsIn.readInt();
        paramsIn.readFully(new byte[8]);
        SmbInput bufferIn = request.getData();
        String filename = bufferIn.readString();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("OPEN_ANDX[flags=" + flags + ",desiredAccess=" + desiredAccess + ",searchAttributes=" + searchAttributes + ",fileAttributes=" + fileAttributes + ",creationTime=" + creationTime + ",openFunction=" + openFunction + ",allocationSize=" + allocationSize + ",filename=" + filename + "]");
        }
        SmbFile smbFile = request.getTree().open(filename, openFunction, false);
        SmbOutput paramsOut = response.getParameters();
        paramsOut.writeShort(smbFile.getFid());
        paramsOut.writeShort(smbFile.getAttributes());
        paramsOut.writeInt((int)(smbFile.getLastWriteTime() / 1000L));
        paramsOut.writeInt((int)smbFile.getDataSize());
        paramsOut.writeShort(desiredAccess);
        paramsOut.writeShort(smbFile.getFileType());
        paramsOut.writeShort(0);
        paramsOut.writeShort(smbFile.getOpenAction());
        paramsOut.writeInt(smbFile.getServerFid());
        paramsOut.writeShort(0);
    }
}

