/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidParameterException;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbFile;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;

class QueryFileInfoHandler
extends SmbCommandHandler {
    private static final int FILE_BASIC_INFO = 257;
    private static final int FILE_STANDARD_INFO = 258;
    private static final int FILE_EA_INFO = 259;
    private static final int FILE_STREAM_INFO = 265;
    private static final String DATA_STREAM = "::$DATA";
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final int DEFAULT_ALLOCATION_SIZE = 4096;

    QueryFileInfoHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        int fid = paramsIn.readUnsignedShort();
        int informationLevel = paramsIn.readUnsignedShort();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("QUERY_FILE_INFO[fid=" + fid + "informationLevel=" + informationLevel + "]");
        }
        SmbOutput dataOut = response.getData();
        SmbFile file = request.getTree().lookup(fid);
        switch (informationLevel) {
            case 257: {
                dataOut.writeLong(file.getCreatedSystemTime().toLong());
                dataOut.writeLong(file.getLastAccessSystemTime().toLong());
                dataOut.writeLong(file.getLastWriteSystemTime().toLong());
                dataOut.writeLong(file.getLastWriteSystemTime().toLong());
                dataOut.writeInt(file.getAttributes());
                dataOut.writeInt(0);
                break;
            }
            case 258: {
                dataOut.writeLong(4096L);
                dataOut.writeLong(file.getDataSize());
                dataOut.writeInt(1);
                dataOut.writeBoolean(false);
                dataOut.writeBoolean(file.isDirectory());
                break;
            }
            case 259: {
                dataOut.writeInt(0);
                break;
            }
            case 265: {
                dataOut.writeInt(0);
                dataOut.writeInt(DATA_STREAM.length());
                dataOut.writeLong(file.getDataSize());
                dataOut.writeLong(4096L);
                dataOut.writeString(DATA_STREAM);
                break;
            }
            default: {
                String msg = "TRANS2_QUERY_FILE_INFO: information level unknown: 0x" + Integer.toHexString(informationLevel);
                throw new InvalidParameterException(msg);
            }
        }
    }
}

