/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidParameterException;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.SystemTime;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;

class QueryFsInformationHandler
extends SmbCommandHandler {
    private static final int INFO_ALLOCATION = 1;
    private static final int INFO_VOLUME = 2;
    private static final int QUERY_FS_VOLUME_INFO = 258;
    private static final int QUERY_FS_SIZE_INFO = 259;
    private static final int QUERY_FS_DEVICE_INFO = 260;
    private static final int QUERY_FS_ATTRIBUTE_INFO = 261;
    private static final int DEFAULT_SERIAL_NUMBER = -889275714;
    private static final int FILE_DEVICE_DISK = 7;
    private static final int FILE_VIRTUAL_VOLUME = 64;
    private static final int FILE_CASE_SENSITIVE_SEARCH = 1;
    private static final int FILE_CASE_PRESERVED_NAMES = 2;
    private static final int MAX_FILE_NAME_LENGTH = 255;
    private static final String FILE_SYSTEM = "NTFS";
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    QueryFsInformationHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        SmbOutput dataOut = response.getData();
        int informationLevel = paramsIn.readUnsignedShort();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("QUERY_FS_INFORMATION[informationLevel=" + informationLevel + "]");
        }
        switch (informationLevel) {
            case 1: {
                dataOut.writeInt(0);
                dataOut.writeInt(8);
                dataOut.writeInt(Integer.MAX_VALUE);
                dataOut.writeInt(Integer.MAX_VALUE);
                dataOut.writeShort(512);
                break;
            }
            case 2: {
                dataOut.writeInt(-889275714);
                String volumeLabel = request.getTree().getVolumeLabel();
                dataOut.writeByte(volumeLabel.length());
                dataOut.writeString(volumeLabel);
                break;
            }
            case 258: {
                dataOut.writeLong(new SystemTime().toLong());
                dataOut.writeInt(-889275714);
                String volumeLabel = request.getTree().getVolumeLabel();
                dataOut.writeInt(volumeLabel.length() * 2);
                dataOut.writeByte(0);
                dataOut.writeByte(0);
                dataOut.writeWideChars(volumeLabel);
                break;
            }
            case 259: {
                dataOut.writeLong(Integer.MAX_VALUE);
                dataOut.writeLong(Integer.MAX_VALUE);
                dataOut.writeInt(8);
                dataOut.writeShort(512);
                break;
            }
            case 260: {
                dataOut.writeInt(7);
                dataOut.writeInt(64);
                break;
            }
            case 261: {
                dataOut.writeInt(3);
                dataOut.writeInt(255);
                dataOut.writeInt(FILE_SYSTEM.length() * 2);
                dataOut.writeWideChars(FILE_SYSTEM);
                break;
            }
            default: {
                String msg = "TRANS2_QUERY_FS_INFORMATION: information level unknown: 0x" + Integer.toHexString(informationLevel);
                throw new InvalidParameterException(msg);
            }
        }
    }
}

