/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.SmbDate;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.SmbTime;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbFile;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;

class QueryInformation2Handler
extends SmbCommandHandler {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final int DEFAULT_ALLOCATION_SIZE = 4096;

    QueryInformation2Handler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput bufferIn = request.getParameters();
        int fid = bufferIn.readUnsignedShort();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("QUERY_INFORMATION2[fid=" + fid + "]");
        }
        SmbFile smbFile = request.getTree().lookup(fid);
        long createdTime = smbFile.getCreatedTime();
        long lastAccessTime = smbFile.getLastAccessTime();
        long lastWriteTime = smbFile.getLastWriteTime();
        SmbOutput paramsOut = response.getParameters();
        paramsOut.writeShort(new SmbDate(createdTime).toShort());
        paramsOut.writeShort(new SmbTime(createdTime).toShort());
        paramsOut.writeShort(new SmbDate(lastAccessTime).toShort());
        paramsOut.writeShort(new SmbTime(lastAccessTime).toShort());
        paramsOut.writeShort(new SmbDate(lastWriteTime).toShort());
        paramsOut.writeShort(new SmbTime(lastWriteTime).toShort());
        paramsOut.writeInt((int)smbFile.getDataSize());
        paramsOut.writeInt(4096);
        paramsOut.writeShort(smbFile.getAttributes());
    }
}

