/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidParameterException;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbFile;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;

class QueryPathInformationHandler
extends SmbCommandHandler {
    private static final int FILE_BASIC_INFO = 257;
    private static final int FILE_STANDARD_INFO = 258;
    private static final int FILE_EA_INFO = 259;
    private static final int FILE_ALL_INFO = 263;
    private static final int FILE_STREAM_INFO = 265;
    private static final String DATA_STREAM = "::$DATA";
    private static final int DEFAULT_ALLOCATION_SIZE = 4096;
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    QueryPathInformationHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        int informationLevel = paramsIn.readUnsignedShort();
        paramsIn.readInt();
        String fileName = paramsIn.readString();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("QUERY_PATH_INFORMATION[informationLevel=" + informationLevel + ",fileName=" + fileName + "]");
        }
        SmbOutput paramsOut = response.getParameters();
        SmbOutput dataOut = response.getData();
        SmbFile file = request.getTree().open(fileName);
        try {
            switch (informationLevel) {
                case 257: {
                    dataOut.writeLong(file.getCreatedSystemTime().toLong());
                    dataOut.writeLong(file.getLastAccessSystemTime().toLong());
                    dataOut.writeLong(file.getLastWriteSystemTime().toLong());
                    dataOut.writeLong(file.getLastWriteSystemTime().toLong());
                    dataOut.writeInt(file.getAttributes());
                    dataOut.writeInt(0);
                    return;
                }
                case 258: {
                    dataOut.writeLong(4096L);
                    dataOut.writeLong(file.getDataSize());
                    dataOut.writeInt(1);
                    dataOut.writeBoolean(false);
                    dataOut.writeBoolean(file.isDirectory());
                    return;
                }
                case 259: {
                    dataOut.writeInt(0);
                    return;
                }
                case 265: {
                    dataOut.writeInt(0);
                    dataOut.writeInt(DATA_STREAM.length());
                    dataOut.writeLong(file.getDataSize());
                    dataOut.writeLong(4096L);
                    dataOut.writeString(DATA_STREAM);
                    return;
                }
                case 263: {
                    dataOut.writeLong(file.getCreatedSystemTime().toLong());
                    dataOut.writeLong(file.getLastAccessSystemTime().toLong());
                    dataOut.writeLong(file.getLastWriteSystemTime().toLong());
                    dataOut.writeLong(file.getLastWriteSystemTime().toLong());
                    dataOut.writeInt(file.getAttributes());
                    dataOut.writeLong(4096L);
                    dataOut.writeLong(file.getDataSize());
                    dataOut.writeInt(1);
                    dataOut.writeBoolean(false);
                    dataOut.writeBoolean(file.isDirectory());
                    dataOut.writeLong(0L);
                    dataOut.writeInt(0);
                    dataOut.writeInt(0);
                    dataOut.writeLong(0L);
                    dataOut.writeLong(0L);
                    dataOut.writeInt(0);
                    dataOut.writeInt(0);
                    String filename = file.getName();
                    dataOut.writeInt(filename.length());
                    dataOut.writeString(filename);
                    return;
                }
                default: {
                    String msg = "TRANS2_QUERY_PATH_INFORMATION: information level unknown: 0x" + Integer.toHexString(informationLevel);
                    throw new InvalidParameterException(msg);
                }
            }
        }
        finally {
            file.close();
        }
    }
}

