/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbFile;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;

class ReadAndXHandler
extends SmbCommandHandler {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final int DATA_OFFSET = 60;

    ReadAndXHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbFile smbFile;
        SmbInput paramsIn = request.getParameters();
        int fid = paramsIn.readUnsignedShort();
        int offset = paramsIn.readInt();
        int maxCount = paramsIn.readUnsignedShort();
        int minCount = paramsIn.readUnsignedShort();
        int maxCountHigh = paramsIn.readInt();
        int remaining = paramsIn.readUnsignedShort();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("READ_ANDX[fid=" + fid + ",offset=" + offset + ",maxCount=" + maxCount + ",minCount=" + minCount + ",maxCountHigh=" + maxCountHigh + ",remaining=" + remaining + "]");
        }
        if ((smbFile = request.getTree().lookup(fid)).isDirectory()) {
            response.setStatus(-1073741638);
            return;
        }
        byte[] buf = new byte[maxCount];
        int len = smbFile.read(buf, offset);
        SmbOutput paramsOut = response.getParameters();
        paramsOut.writeShort(-1);
        paramsOut.writeShort(0);
        paramsOut.writeShort(0);
        paramsOut.writeShort(len);
        paramsOut.writeShort(60);
        paramsOut.writeInt(0);
        paramsOut.write(new byte[6]);
        SmbOutput dataOut = response.getData();
        dataOut.writeByte(1);
        dataOut.write(buf, 0, len);
    }
}

