/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;
import com.day.smb.server.SmbServer;

class SessionSetupAndXHandler
extends SmbCommandHandler {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    SessionSetupAndXHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        int maxBufferSize = paramsIn.readUnsignedShort();
        int maxMpxCount = paramsIn.readUnsignedShort();
        int vcNumber = paramsIn.readUnsignedShort();
        int sessionKey = paramsIn.readInt();
        int caseInsensitivePasswordLength = paramsIn.readUnsignedShort();
        int caseSensitivePasswordLength = paramsIn.readUnsignedShort();
        paramsIn.readInt();
        int capabilities = paramsIn.readInt();
        SmbInput dataIn = request.getData();
        byte[] buf = new byte[caseInsensitivePasswordLength];
        dataIn.readFully(buf);
        String caseInsensitivePassword = new String(buf);
        buf = new byte[caseSensitivePasswordLength];
        dataIn.readFully(buf);
        String caseSensitivePassword = new String(buf);
        String accountName = dataIn.readString();
        String domainName = dataIn.readString();
        String nativeOS = dataIn.readString();
        String nativeLanMan = dataIn.readString();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("SESSION_SETUP_ANDX[maxBufferSize=" + maxBufferSize + ",maxMpxCount=" + maxMpxCount + ",vcNumber=" + vcNumber + ",sessionKey=" + sessionKey + ",capabilities=" + capabilities + ",caseInsensitivePassword=" + caseInsensitivePassword + ",caseSensitivePassword=" + caseSensitivePassword + ",accountName=" + accountName + ",domainName=" + domainName + ",nativeOS=" + nativeOS + ",nativeLanMan=" + nativeLanMan + "]");
        }
        response.createSession(accountName, domainName, nativeOS, nativeLanMan);
        SmbOutput paramsOut = response.getParameters();
        paramsOut.writeShort(0);
        SmbOutput dataOut = response.getData();
        SmbServer server = request.getServer();
        dataOut.writeString(server.getNativeOS());
        dataOut.writeString(server.getNativeLanMan());
        dataOut.writeString(server.getPrimaryDomain());
    }
}

