/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidParameterException;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.SystemTime;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbFile;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;

class SetFileInfoHandler
extends SmbCommandHandler {
    private static final int BASIC_INFO = 257;
    private static final int DISPOSITION_INFO = 258;
    private static final int ALLOCATION_INFO = 259;
    private static final int END_OF_FILE_INFO = 260;
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    SetFileInfoHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        SmbInput dataIn = request.getData();
        int fid = paramsIn.readUnsignedShort();
        int informationLevel = paramsIn.readUnsignedShort();
        paramsIn.readUnsignedShort();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("SET_FILE_INFO[fid=" + fid + ", informationLevel=" + informationLevel + "]");
        }
        SmbFile file = request.getTree().lookup(fid);
        SmbOutput paramsOut = response.getParameters();
        SmbOutput dataOut = response.getData();
        switch (informationLevel) {
            case 257: {
                dataIn.readLong();
                dataIn.readLong();
                long lastWrite = dataIn.readLong();
                dataIn.readLong();
                dataIn.readInt();
                if (lastWrite != 0L) {
                    file.setLastWriteTime(new SystemTime(lastWrite).getMillis());
                }
                paramsOut.writeShort(0);
                break;
            }
            case 258: {
                boolean deleted = dataIn.readBoolean();
                if (deleted) {
                    file.delete();
                }
                paramsOut.writeShort(0);
                break;
            }
            case 259: {
                long allocationSize = dataIn.readLong();
                paramsOut.writeShort(0);
                break;
            }
            case 260: {
                long length = dataIn.readLong();
                request.getTree().lookup(fid).setLength((int)length);
                paramsOut.writeShort(0);
                break;
            }
            default: {
                String msg = "TRANS2_SET_FILE_INFO: information level unknown: 0x" + Integer.toHexString(informationLevel);
                throw new InvalidParameterException(msg);
            }
        }
    }
}

