/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.SmbException;
import com.day.smb.server.CheckDirectoryHandler;
import com.day.smb.server.CloseHandler;
import com.day.smb.server.CreateDirectoryHandler;
import com.day.smb.server.DeleteDirectoryHandler;
import com.day.smb.server.DeleteHandler;
import com.day.smb.server.EchoHandler;
import com.day.smb.server.FindClose2Handler;
import com.day.smb.server.FlushHandler;
import com.day.smb.server.LogoffAndXHandler;
import com.day.smb.server.NegotiateHandler;
import com.day.smb.server.NtCreateAndXHandler;
import com.day.smb.server.NtTransactHandler;
import com.day.smb.server.OpenAndXHandler;
import com.day.smb.server.QueryInformation2Handler;
import com.day.smb.server.QueryInformationDiskHandler;
import com.day.smb.server.QueryInformationHandler;
import com.day.smb.server.ReadAndXHandler;
import com.day.smb.server.RenameHandler;
import com.day.smb.server.SessionSetupAndXHandler;
import com.day.smb.server.SetInformationHandler;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;
import com.day.smb.server.Transaction2Handler;
import com.day.smb.server.TransactionHandler;
import com.day.smb.server.TreeConnectAndXHandler;
import com.day.smb.server.TreeDisconnectHandler;
import com.day.smb.server.UnknownCommandHandler;
import com.day.smb.server.WriteAndXHandler;
import com.day.smb.server.WriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SmbCommandHandler {
    protected static Logger cmdLog = LoggerFactory.getLogger((String)"com.day.smb");
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final byte[] ANDX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final SmbCommandHandler[] HANDLERS_00_14 = new SmbCommandHandler[]{new CreateDirectoryHandler(), new DeleteDirectoryHandler(), null, null, new CloseHandler(), new FlushHandler(), new DeleteHandler(), new RenameHandler(), new QueryInformationHandler(), new SetInformationHandler(), null, new WriteHandler(), null, null, null, null, new CheckDirectoryHandler(), null, null, null, null};
    private static final SmbCommandHandler[] HANDLERS_1A_35 = new SmbCommandHandler[]{null, null, null, null, null, null, null, null, null, new QueryInformation2Handler(), null, new TransactionHandler(), null, null, null, null, null, new EchoHandler(), null, new OpenAndXHandler(), new ReadAndXHandler(), new WriteAndXHandler(), null, null, new Transaction2Handler(), null, new FindClose2Handler(), null};
    private static final SmbCommandHandler[] HANDLERS_70_75 = new SmbCommandHandler[]{null, new TreeDisconnectHandler(), new NegotiateHandler(), new SessionSetupAndXHandler(), new LogoffAndXHandler(), new TreeConnectAndXHandler()};
    private static final SmbCommandHandler[] HANDLERS_80_84 = new SmbCommandHandler[]{new QueryInformationDiskHandler(), null, null, null, null};
    private static final SmbCommandHandler[] HANDLERS_AO_A5 = new SmbCommandHandler[]{new NtTransactHandler(), null, new NtCreateAndXHandler(), null, null, null};
    private static final SmbCommandHandler UNKNOWN = new UnknownCommandHandler("SMB_COM_");

    SmbCommandHandler() {
    }

    public static SmbCommandHandler lookup(int command) {
        SmbCommandHandler handler = null;
        if (command >= 0 && command <= 20) {
            handler = HANDLERS_00_14[command];
        } else if (command >= 26 && command <= 53) {
            handler = HANDLERS_1A_35[command - 26];
        } else if (command >= 112 && command <= 117) {
            handler = HANDLERS_70_75[command - 112];
        } else if (command >= 128 && command <= 132) {
            handler = HANDLERS_80_84[command - 128];
        } else if (command >= 160 && command <= 165) {
            handler = HANDLERS_AO_A5[command - 160];
        }
        if (handler == null) {
            handler = UNKNOWN;
        }
        return handler;
    }

    public static boolean isAndX(int command) {
        if (command >= 0 && command < ANDX.length) {
            return ANDX[command] == 1;
        }
        return false;
    }

    public abstract void handle(SmbRequest var1, SmbResponse var2) throws SmbException;
}

