/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.SmbException;
import com.day.smb.SystemTime;
import com.day.smb.spi.File;
import java.util.Date;

class SmbFile {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private final File file;
    private final Integer fid;
    private final int openAction;
    private final long createdTime;
    private long lastWriteTime;
    private final int attributes;

    protected SmbFile(File file, int fid, int openAction) {
        this.fid = new Integer(fid);
        this.file = file;
        this.openAction = openAction;
        this.createdTime = file.lastModified();
        int attributes = 0;
        if (file.isDirectory()) {
            attributes |= 0x10;
        } else if (file.isFile()) {
            attributes |= 0x80;
        }
        this.attributes = attributes;
    }

    protected SmbFile(File file) {
        this(file, 0, 1);
    }

    public int getFid() {
        return this.fid;
    }

    public int getOpenAction() {
        return this.openAction;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public boolean isDirectory() {
        return (this.attributes & 0x10) != 0;
    }

    public String getName() {
        return this.file.getName();
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public SystemTime getCreatedSystemTime() {
        return new SystemTime(new Date(this.getCreatedTime()));
    }

    public long getLastAccessTime() {
        return this.getLastWriteTime();
    }

    public SystemTime getLastAccessSystemTime() {
        return new SystemTime(new Date(this.getLastAccessTime()));
    }

    public long getLastWriteTime() {
        if (this.lastWriteTime != 0L) {
            return this.lastWriteTime;
        }
        return this.file.lastModified();
    }

    public SystemTime getLastWriteSystemTime() {
        return new SystemTime(new Date(this.getLastWriteTime()));
    }

    public void setLastWriteTime(long ms) {
        this.lastWriteTime = ms;
    }

    public long getDataSize() {
        if (this.file.isDirectory()) {
            return 0L;
        }
        return this.file.length();
    }

    public int getAccessMode() {
        return 0;
    }

    public int getFileType() {
        return 0;
    }

    public int getServerFid() {
        return 0;
    }

    protected Object getKey() {
        return this.fid;
    }

    public int read(byte[] data, int offset) throws SmbException {
        return this.file.read(data, offset);
    }

    public void write(byte[] data, int offset) throws SmbException {
        this.file.write(data, offset);
    }

    public void setLength(int length) throws SmbException {
        this.file.setLength(length);
    }

    public void flush() {
        this.file.flush();
    }

    public boolean delete() {
        return this.file.delete();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[fid=0x");
        buf.append(Integer.toHexString(this.fid));
        buf.append(",file=");
        buf.append(this.file.getName());
        buf.append(']');
        return buf.toString();
    }

    public void close() {
        this.file.close();
    }
}

