/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.SmbException;
import com.day.smb.SmbHeader;
import com.day.smb.SmbInput;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbServer;
import com.day.smb.server.SmbSession;
import com.day.smb.server.SmbTree;

class SmbRequest {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private final SmbServer server;
    private final SmbHeader header;
    private final SmbInput input;
    private int command;
    private boolean unicode;
    private int wordCount;
    private SmbInput parameters;
    private SmbInput data;
    private int andXCommand;
    private int andXOffset;

    public SmbRequest(SmbServer server, SmbHeader header, SmbInput input) {
        this.server = server;
        this.header = header;
        this.input = input;
        this.command = header.getCommand();
    }

    public SmbRequest(SmbRequest outer, int command, SmbInput parameters, SmbInput data) {
        this.server = outer.server;
        this.header = outer.header;
        this.input = SmbInput.NULL;
        this.command = command;
        this.parameters = parameters;
        this.data = data;
    }

    public SmbHeader getHeader() {
        return this.header;
    }

    public boolean isUnicode() {
        return this.header.isUnicode();
    }

    public int getCommand() {
        return this.command;
    }

    protected boolean isAndX() {
        return SmbCommandHandler.isAndX(this.command);
    }

    public int getWordCount() throws SmbException {
        this.getParameters();
        return this.wordCount;
    }

    public SmbInput getParameters() throws SmbException {
        if (this.parameters == null) {
            this.wordCount = this.input.readUnsignedByte();
            this.parameters = this.input.getInput(this.wordCount * 2);
            this.parameters.setUnicode(this.isUnicode());
            this.input.skip(this.wordCount * 2);
            if (this.isAndX()) {
                this.andXCommand = this.parameters.readUnsignedByte();
                this.parameters.readUnsignedByte();
                this.andXOffset = this.parameters.readUnsignedShort();
            } else {
                this.andXCommand = 255;
            }
        }
        return this.parameters;
    }

    public SmbInput getData() throws SmbException {
        if (this.parameters == null) {
            this.getParameters();
        }
        if (this.data == null) {
            int byteCount = this.input.readUnsignedShort();
            this.data = this.input.getInput(byteCount);
            this.data.setUnicode(this.isUnicode());
            this.input.skip(byteCount);
        }
        return this.data;
    }

    public SmbServer getServer() {
        return this.server;
    }

    public SmbSession getSession() throws SmbException {
        return this.server.lookupSession(this.header.getUid());
    }

    public SmbTree getTree() throws SmbException {
        return this.getSession().lookup(this.header.getTid());
    }

    public SmbInput getInput(int offset, int length) throws SmbException {
        SmbInput input = this.input.getInput(offset, length);
        input.setUnicode(this.isUnicode());
        return input;
    }

    protected void finish() throws SmbException {
        if (this.parameters == null) {
            this.getParameters();
        }
        if (this.data == null) {
            this.getData();
        }
        this.command = this.andXCommand;
        if (this.command != 255) {
            this.input.seek(this.andXOffset);
        }
        this.data = null;
        this.parameters = null;
    }
}

