/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.SmbHeader;
import com.day.smb.SmbOutput;
import com.day.smb.server.SmbServer;
import com.day.smb.server.SmbSession;

class SmbResponse {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private final SmbServer server;
    private final SmbHeader header;
    private final SmbOutput output;
    private SmbOutput parameters;
    private SmbOutput data;
    private boolean isAndX;

    public SmbResponse(SmbServer server, SmbHeader header, SmbOutput output) {
        this.server = server;
        this.header = header;
        this.output = output;
    }

    public SmbResponse(SmbResponse outer) {
        this.server = outer.server;
        this.header = outer.header;
        this.output = SmbOutput.NULL;
    }

    protected void setAndX(boolean isAndX) {
        this.isAndX = isAndX;
    }

    public void setStatus(int status) {
        this.header.setStatus(status);
    }

    public int getStatus() {
        return this.header.getStatus();
    }

    public SmbOutput getParameters() {
        if (this.parameters == null) {
            this.parameters = new SmbOutput();
            this.parameters.setUnicode(this.header.isUnicode());
        }
        return this.parameters;
    }

    public SmbOutput getData() {
        if (this.data == null) {
            this.data = new SmbOutput();
            this.data.setUnicode(this.header.isUnicode());
            if (this.output != SmbOutput.NULL) {
                this.data.setAlignment(1);
            }
        }
        return this.data;
    }

    public void setUid(int uid) {
        this.header.setUid(uid);
    }

    public void setTid(int tid) {
        this.header.setTid(tid);
    }

    public SmbSession createSession(String accountName, String domainName, String nativeOS, String nativeLanMan) {
        SmbSession smbSession = this.server.createSession(accountName, domainName, nativeOS, nativeLanMan);
        this.header.setUid(smbSession.getUid());
        return smbSession;
    }

    protected void finish(int nextCommand) {
        if (this.getStatus() != 0 && this.getStatus() != -1073741802) {
            this.output.writeByte(0);
            this.output.writeShort(0);
        } else {
            if (this.parameters == null) {
                this.getParameters();
            }
            if (this.data == null) {
                this.getData();
            }
            if (this.isAndX) {
                this.output.writeByte(this.parameters.getLength() / 2 + 2);
                this.output.writeByte(nextCommand);
                this.output.writeByte(0);
                int nextOffset = 0;
                if (nextCommand != 255 && ((nextOffset = 32 + this.output.getLength() + 2 + this.parameters.getLength() + 2 + this.data.getLength()) & 1) != 0) {
                    ++nextOffset;
                }
                this.output.writeShort(nextOffset);
            } else {
                this.output.writeByte(this.parameters.getLength() / 2);
            }
            this.output.append(this.parameters);
            this.output.writeShort(this.data.getLength());
            this.output.append(this.data);
            if (nextCommand != 255) {
                this.output.align(2);
            }
        }
        this.data = null;
        this.parameters = null;
    }
}

