/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidHandleException;
import com.day.smb.NoSuchFileException;
import com.day.smb.SmbException;
import com.day.smb.fs.FileSystemShare;
import com.day.smb.server.IPCShare;
import com.day.smb.server.SmbSession;
import com.day.smb.server.SmbShare;
import com.day.smb.server.SmbSocketHandler;
import com.day.smb.spi.Share;
import com.day.smb.spi.Tree;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbServer {
    private static final String NATIVE_LANMAN = "CRX SMB";
    private static Logger log = LoggerFactory.getLogger((Class)SmbServer.class);
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private InetSocketAddress address;
    private String primaryDomain;
    private ServerSocket listener;
    private final HashMap shares = new HashMap();
    private final HashMap sessions = new HashMap();
    private int uidCounter;

    public SmbServer(InetSocketAddress address) {
        this.address = address;
        this.addShare("IPC$", new IPCShare());
    }

    public void start() throws SocketException, IOException {
        this.listener = new ServerSocket(this.address.getPort(), 50, this.address.getAddress());
        Thread t = new Thread(new Runnable(){

            public void run() {
                SmbServer.this.accept();
            }
        }, "SMB Server");
        t.start();
    }

    public void stop() {
        if (this.listener != null) {
            try {
                this.listener.close();
            }
            catch (IOException e) {
                log.warn("I/O error while closing listener: " + e.getMessage());
            }
        }
    }

    protected void accept() {
        while (!this.listener.isClosed()) {
            try {
                this.handle(this.listener.accept());
            }
            catch (IOException e) {
                if (this.listener.isClosed()) continue;
                e.printStackTrace(System.err);
            }
        }
    }

    protected void handle(final Socket client) {
        String ipAddr = client.getInetAddress().getHostAddress();
        int port = client.getPort();
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    new SmbSocketHandler(SmbServer.this).handle(client);
                }
                finally {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        String msg = "Unable to close socket.";
                        log.warn(msg, (Throwable)e);
                    }
                }
            }
        }, "SMB Worker - " + ipAddr + ":" + port);
        t.start();
    }

    public SmbSession createSession(String accountName, String domainName, String nativeOS, String nativeLanMan) {
        SmbSession smbSession = new SmbSession(this, ++this.uidCounter, accountName, domainName, nativeOS, nativeLanMan);
        this.sessions.put(smbSession.getKey(), smbSession);
        return smbSession;
    }

    public SmbSession lookupSession(int uid) throws SmbException {
        SmbSession smbSession = (SmbSession)this.sessions.get(new Integer(uid));
        if (smbSession == null) {
            String msg = "Session not found: " + uid;
            throw new InvalidHandleException(msg);
        }
        return smbSession;
    }

    protected void destroySession(SmbSession session) {
        this.sessions.remove(session.getKey());
    }

    public void addShare(String shareName, Share share) {
        SmbShare smbShare = new SmbShare(shareName, share);
        this.shares.put(shareName.toUpperCase(), smbShare);
    }

    public Tree connectShare(String shareName, String username, String password) throws SmbException {
        SmbShare share = (SmbShare)this.shares.get(shareName);
        if (share == null) {
            share = (SmbShare)this.shares.get(shareName.toUpperCase());
        }
        if (share == null) {
            String msg = "Share not found: " + shareName;
            throw new NoSuchFileException(msg);
        }
        return share.connect(username, password);
    }

    public Collection enumShares() {
        return this.shares.values();
    }

    public SmbShare getShare(String name) {
        return (SmbShare)this.shares.get(name.toUpperCase());
    }

    public String getNativeOS() {
        return System.getProperty("os.name");
    }

    public String getNativeLanMan() {
        return NATIVE_LANMAN;
    }

    public String getPrimaryDomain() {
        return this.primaryDomain != null ? this.primaryDomain : "";
    }

    public void setPrimaryDomain(String primaryDomain) {
        this.primaryDomain = primaryDomain;
    }

    public static void usage() {
        System.out.println("Options: ip-address port path share [domain]");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4 || args.length > 5) {
            SmbServer.usage();
        }
        InetAddress addr = InetAddress.getByName(args[0]);
        int port = Integer.parseInt(args[1]);
        String filepath = args[2];
        String shareName = args[3];
        String primaryDomain = null;
        if (args.length > 4) {
            primaryDomain = args[4];
        }
        SmbServer server = new SmbServer(new InetSocketAddress(addr, port));
        server.setPrimaryDomain(primaryDomain);
        server.addShare(shareName, new FileSystemShare(filepath));
        server.start();
    }
}

