/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidHandleException;
import com.day.smb.SmbException;
import com.day.smb.server.SmbServer;
import com.day.smb.server.SmbTree;
import java.util.HashMap;

class SmbSession {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private final SmbServer server;
    private final HashMap trees = new HashMap();
    private int tidCounter;
    private final Integer uid;
    private final String accountName;
    private final String domainName;
    private final String nativeOS;
    private final String nativeLanMan;

    protected SmbSession(SmbServer server, int uid, String accountName, String domainName, String nativeOS, String nativeLanMan) {
        this.server = server;
        this.uid = new Integer(uid);
        this.accountName = accountName;
        this.domainName = domainName;
        this.nativeOS = nativeOS;
        this.nativeLanMan = nativeLanMan;
    }

    public int getUid() {
        return this.uid;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getNativeOS() {
        return this.nativeOS;
    }

    public String getNativeLanMan() {
        return this.nativeLanMan;
    }

    protected Object getKey() {
        return this.uid;
    }

    public SmbTree connect(String password, String path, String service) throws SmbException {
        String shareName = path;
        int index = shareName.lastIndexOf(92);
        if (index != -1) {
            shareName = shareName.substring(index + 1);
        }
        SmbTree smbTree = new SmbTree(this, ++this.tidCounter, path, service, this.server.connectShare(shareName, this.accountName, password));
        this.trees.put(smbTree.getKey(), smbTree);
        return smbTree;
    }

    public SmbTree lookup(int tid) throws SmbException {
        SmbTree smbTree = (SmbTree)this.trees.get(new Integer(tid));
        if (smbTree == null) {
            String msg = "Tree not found: " + tid;
            throw new InvalidHandleException(msg);
        }
        return smbTree;
    }

    protected void disconnect(SmbTree smbTree) {
        this.trees.remove(smbTree.getKey());
    }

    public void logoff() {
        this.server.destroySession(this);
    }
}

