/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.SmbException;
import com.day.smb.SmbHeader;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.Util;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;
import com.day.smb.server.SmbServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbSocketHandler {
    private static Logger log = LoggerFactory.getLogger((Class)SmbSocketHandler.class);
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private final SmbServer server;
    private InputStream in;
    private OutputStream out;
    private SmbInput input;
    private SmbOutput output;
    private SmbHeader header;
    private SmbCommandHandler cmdHandler;

    public SmbSocketHandler(SmbServer server) {
        this.server = server;
    }

    private void init(Socket client) throws IOException {
        client.setTcpNoDelay(true);
        this.in = new BufferedInputStream(client.getInputStream());
        this.out = new BufferedOutputStream(client.getOutputStream());
    }

    private boolean isNBSessionRequest(int length) throws IOException {
        int nbType = (length & 0xFF000000) >>> 24;
        if (nbType == 129) {
            byte[] data = new byte[length & 0xFFFFFF];
            Util.readFully(this.in, data);
            Util.writeInt(this.out, -2113929216);
            this.out.flush();
            return true;
        }
        return false;
    }

    private void readHeader(int length) throws IOException, SmbException {
        if (length < 34 || length > 65535) {
            String msg = "SmbHeader length outside range [34,65535]: " + length;
            throw new SmbException(msg);
        }
        byte[] data = new byte[length];
        Util.readFully(this.in, data);
        this.input = new SmbInput(data);
        this.header = new SmbHeader();
        this.header.read(this.input);
        this.output = new SmbOutput();
    }

    private void lookupCommandHandler(int command) {
        this.cmdHandler = SmbCommandHandler.lookup(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(Socket client) {
        try {
            this.init(client);
        }
        catch (IOException e) {
            String msg = "Unable to initialize socket.";
            log.error(msg, (Throwable)e);
            return;
        }
        while (true) {
            String msg;
            try {
                int length;
                while (this.isNBSessionRequest(length = Util.readInt(this.in))) {
                }
                this.readHeader(length);
            }
            catch (EOFException e) {
                msg = "No packet length received, probably disconnected.";
                log.debug(msg, (Throwable)e);
                return;
            }
            catch (IOException e) {
                msg = "I/O error while reading header.";
                log.error(msg, (Throwable)e);
                return;
            }
            catch (SmbException e) {
                msg = "SMB error while reading header.";
                log.error(msg, (Throwable)e);
                return;
            }
            SmbRequest request = new SmbRequest(this.server, this.header, this.input);
            SmbResponse response = new SmbResponse(this.server, this.header, this.output);
            try {
                do {
                    response.setAndX(request.isAndX());
                    this.lookupCommandHandler(request.getCommand());
                    try {
                        this.cmdHandler.handle(request, response);
                    }
                    catch (SmbException e) {
                        this.log(e);
                        response.setStatus(e.getStatus());
                    }
                    finally {
                        try {
                            request.finish();
                        }
                        catch (SmbException e) {
                            log.warn("Error finishing request: " + e.getMessage());
                            log.debug("Stack trace: ", (Throwable)e);
                            response.setStatus(-1073741823);
                        }
                        response.finish(request.getCommand());
                    }
                } while (request.getCommand() != 255 && response.getStatus() == 0);
                continue;
            }
            finally {
                try {
                    this.sendHeaderAndData(response.getStatus());
                }
                catch (IOException e) {
                    String msg2 = "Unable to send back header and data.";
                    log.error(msg2, (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    protected void log(SmbException e) {
        String msg = "Error processing command: {}";
        switch (e.getStatus()) {
            case -1073741811: 
            case -1073741809: 
            case -1073741772: 
            case -1073741771: 
            case -1073741638: {
                log.info(msg, (Object)e.getMessage());
                break;
            }
            default: {
                log.warn(msg, (Object)e.getMessage());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Stack trace: ", (Throwable)e);
        }
    }

    protected void sendHeaderAndData(int status) throws IOException {
        SmbOutput headerAndData = new SmbOutput();
        SmbHeader outHeader = new SmbHeader(this.header);
        outHeader.setFlags(144);
        outHeader.setFlags2(49153);
        outHeader.setStatus(status);
        outHeader.write(headerAndData);
        headerAndData.append(this.output);
        Util.writeInt(this.out, headerAndData.getLength());
        this.out.write(headerAndData.getByteArray(), 0, headerAndData.getLength());
        this.out.flush();
    }
}

