/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidHandleException;
import com.day.smb.ObjectNameCollisionException;
import com.day.smb.ObjectNameNotFoundException;
import com.day.smb.SmbException;
import com.day.smb.server.SmbFile;
import com.day.smb.server.SmbSession;
import com.day.smb.spi.File;
import com.day.smb.spi.Tree;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbTree {
    private static Logger log = LoggerFactory.getLogger((Class)SmbTree.class);
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private final HashMap files = new HashMap();
    private int fidCounter;
    private final SmbSession smbSession;
    private final Integer tid;
    private final String path;
    private final String service;
    private final Tree tree;

    protected SmbTree(SmbSession smbSession, int tid, String path, String service, Tree tree) {
        this.smbSession = smbSession;
        this.tid = new Integer(tid);
        this.path = path;
        this.service = service;
        this.tree = tree;
    }

    public int getTid() {
        return this.tid;
    }

    public String getPath() {
        return this.path;
    }

    public String getService() {
        return this.service;
    }

    public String getVolumeLabel() {
        return this.tree.getShare().getDescription();
    }

    protected Object getKey() {
        return this.tid;
    }

    public SmbFile open(String filename) throws SmbException {
        return this.open(filename, 1, false);
    }

    public SmbFile open(String filename, int openFunction, boolean directory) throws SmbException {
        int openAction = 0;
        if (!this.tree.exists(filename = this.normalize(filename))) {
            if ((openFunction & 0x10) == 0) {
                String msg = "File not found: " + filename;
                throw new ObjectNameNotFoundException(msg);
            }
            if (directory) {
                this.tree.createDirectory(filename);
            } else {
                this.tree.createFile(filename);
            }
            openAction = 2;
        } else {
            switch (openFunction & 3) {
                case 2: {
                    openAction = 3;
                    break;
                }
                case 1: {
                    openAction = 1;
                    break;
                }
                default: {
                    String msg = "File exists: " + filename;
                    throw new ObjectNameCollisionException(msg);
                }
            }
        }
        File file = this.tree.open(filename);
        if (openAction == 3) {
            file.setLength(0);
        }
        SmbFile smbFile = new SmbFile(file, ++this.fidCounter, openAction);
        this.files.put(smbFile.getKey(), smbFile);
        return smbFile;
    }

    public SmbFile lookup(int fid) throws SmbException {
        SmbFile smbFile = (SmbFile)this.files.get(new Integer(fid));
        if (smbFile == null) {
            String msg = "File ID not found: " + fid;
            throw new InvalidHandleException(msg);
        }
        return smbFile;
    }

    public SmbFile[] list(String pattern) {
        File[] files = this.tree.list(this.normalize(pattern));
        SmbFile[] smbFiles = new SmbFile[files.length];
        for (int i = 0; i < smbFiles.length; ++i) {
            smbFiles[i] = new SmbFile(files[i]);
        }
        return smbFiles;
    }

    public boolean delete(String name) {
        return this.tree.delete(this.normalize(name));
    }

    public boolean exists(String name) {
        return this.tree.exists(this.normalize(name));
    }

    public boolean rename(String oldName, String newName) {
        return this.tree.rename(this.normalize(oldName), this.normalize(newName));
    }

    public boolean createDirectory(String name) throws SmbException {
        return this.tree.createDirectory(this.normalize(name));
    }

    public boolean deleteDirectory(String name) throws SmbException {
        return this.tree.delete(this.normalize(name));
    }

    public void flush() {
        this.tree.flush();
    }

    public void disconnect() {
        this.smbSession.disconnect(this);
    }

    private String normalize(String name) {
        if (!(name = name.replace('\\', '/')).startsWith("/")) {
            name = "/" + name;
        }
        if (name.length() > 1 && name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }
}

