/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.server.FindFirst2Handler;
import com.day.smb.server.FindNext2Handler;
import com.day.smb.server.QueryFileInfoHandler;
import com.day.smb.server.QueryFsInformationHandler;
import com.day.smb.server.QueryPathInformationHandler;
import com.day.smb.server.SetFileInfoHandler;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;
import com.day.smb.server.UnknownCommandHandler;

class Transaction2Handler
extends SmbCommandHandler {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final int PARAMETER_OFFSET = 55;
    private static final SmbCommandHandler UNKNOWN = new UnknownCommandHandler("TRANS2_");

    Transaction2Handler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        int totalParameterCount = paramsIn.readUnsignedShort();
        int totalDataCount = paramsIn.readUnsignedShort();
        int maxParameterCount = paramsIn.readUnsignedShort();
        int maxDataCount = paramsIn.readUnsignedShort();
        int maxSetupCount = paramsIn.readUnsignedByte();
        paramsIn.readUnsignedByte();
        int flags = paramsIn.readUnsignedShort();
        int timeout = paramsIn.readInt();
        paramsIn.readUnsignedShort();
        int parameterCount = paramsIn.readUnsignedShort();
        int parameterOffset = paramsIn.readUnsignedShort();
        int dataCount = paramsIn.readUnsignedShort();
        int dataOffset = paramsIn.readUnsignedShort();
        int setupCount = paramsIn.readUnsignedByte();
        paramsIn.readUnsignedByte();
        byte[] buf = new byte[setupCount * 2];
        paramsIn.readFully(buf);
        SmbInput setup = new SmbInput(buf, request.isUnicode());
        int function = setup.readUnsignedShort();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("TRANSACTION2[function=" + function + "]");
        }
        SmbInput subParamsIn = request.getInput(parameterOffset, parameterCount);
        SmbInput subDataIn = request.getInput(dataOffset, dataCount);
        SmbRequest innerRequest = new SmbRequest(request, function, subParamsIn, subDataIn);
        SmbResponse innerResponse = new SmbResponse(response);
        SmbCommandHandler handler = null;
        switch (function) {
            case 3: {
                handler = new QueryFsInformationHandler();
                break;
            }
            case 1: {
                handler = new FindFirst2Handler();
                break;
            }
            case 2: {
                handler = new FindNext2Handler();
                break;
            }
            case 5: {
                handler = new QueryPathInformationHandler();
                break;
            }
            case 7: {
                handler = new QueryFileInfoHandler();
                break;
            }
            case 8: {
                handler = new SetFileInfoHandler();
                break;
            }
            default: {
                handler = UNKNOWN;
            }
        }
        handler.handle(innerRequest, innerResponse);
        if (response.getStatus() == 0) {
            SmbOutput subParamsOut = innerResponse.getParameters();
            SmbOutput subDataOut = innerResponse.getData();
            SmbOutput dataOut = response.getData();
            dataOut.align(2);
            int paramOutOffset = 55 + dataOut.getLength();
            dataOut.append(subParamsOut);
            dataOut.align(2);
            int dataOutOffset = 55 + dataOut.getLength();
            dataOut.append(subDataOut);
            SmbOutput paramsOut = response.getParameters();
            paramsOut.writeShort(subParamsOut.getLength());
            paramsOut.writeShort(subDataOut.getLength());
            paramsOut.writeShort(0);
            paramsOut.writeShort(subParamsOut.getLength());
            paramsOut.writeShort(paramOutOffset);
            paramsOut.writeShort(0);
            paramsOut.writeShort(subDataOut.getLength());
            paramsOut.writeShort(dataOutOffset);
            paramsOut.writeShort(0);
            paramsOut.writeByte(0);
            paramsOut.writeByte(0);
        }
    }
}

