/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidParameterException;
import com.day.smb.NotImplementedException;
import com.day.smb.ObjectNameNotFoundException;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;
import com.day.smb.server.SmbShare;
import java.util.Collection;
import java.util.Iterator;

class TransactionHandler
extends SmbCommandHandler {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final String PIPE_LANMAN = "\\PIPE\\LANMAN";
    private static final int PARAMETER_OFFSET = 55;

    TransactionHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        int totalParameterCount = paramsIn.readUnsignedShort();
        int totalDataCount = paramsIn.readUnsignedShort();
        int maxParameterCount = paramsIn.readUnsignedShort();
        int maxDataCount = paramsIn.readUnsignedShort();
        int maxSetupCount = paramsIn.readUnsignedByte();
        paramsIn.readUnsignedByte();
        int flags = paramsIn.readUnsignedShort();
        int timeout = paramsIn.readInt();
        paramsIn.readUnsignedShort();
        int parameterCount = paramsIn.readUnsignedShort();
        int parameterOffset = paramsIn.readUnsignedShort();
        int dataCount = paramsIn.readUnsignedShort();
        int dataOffset = paramsIn.readUnsignedShort();
        int setupCount = paramsIn.readUnsignedByte();
        paramsIn.readUnsignedByte();
        byte[] buf = new byte[setupCount * 2];
        paramsIn.readFully(buf);
        SmbInput setup = new SmbInput(buf, request.isUnicode());
        SmbInput dataIn = request.getData();
        String name = dataIn.readString();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("TRANSACTION[name=" + name + "]");
        }
        SmbInput subParamsIn = request.getInput(parameterOffset, parameterCount);
        SmbInput subDataIn = request.getInput(dataOffset, dataCount);
        SmbRequest innerRequest = new SmbRequest(request, 255, subParamsIn, subDataIn);
        SmbResponse innerResponse = new SmbResponse(response);
        if (!name.equals(PIPE_LANMAN)) {
            String msg = "Function not implemented: " + name;
            throw new NotImplementedException(msg);
        }
        this.handleLanman(innerRequest, innerResponse);
        if (response.getStatus() == 0) {
            SmbOutput subParamsOut = innerResponse.getParameters();
            SmbOutput subDataOut = innerResponse.getData();
            SmbOutput dataOut = response.getData();
            dataOut.align(2);
            int paramOutOffset = 55 + dataOut.getLength();
            dataOut.append(subParamsOut);
            dataOut.align(2);
            int dataOutOffset = 55 + dataOut.getLength();
            dataOut.append(subDataOut);
            SmbOutput paramsOut = response.getParameters();
            paramsOut.writeShort(subParamsOut.getLength());
            paramsOut.writeShort(subDataOut.getLength());
            paramsOut.writeShort(0);
            paramsOut.writeShort(subParamsOut.getLength());
            paramsOut.writeShort(paramOutOffset);
            paramsOut.writeShort(0);
            paramsOut.writeShort(subDataOut.getLength());
            paramsOut.writeShort(dataOutOffset);
            paramsOut.writeShort(0);
            paramsOut.writeByte(0);
            paramsOut.writeByte(0);
        }
    }

    private void handleLanman(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        int functionCode = paramsIn.readUnsignedShort();
        if (functionCode == 0) {
            String parameterDescriptor = paramsIn.readASCII();
            String returnDescriptor = paramsIn.readASCII();
            if (!parameterDescriptor.equals("WrLeh")) {
                String msg = "Expected: 'WrLeh', got: " + parameterDescriptor;
                throw new InvalidParameterException(msg);
            }
            if (!returnDescriptor.equals("B13BWz")) {
                String msg = "Expected: 'B13BWz', got: " + returnDescriptor;
                throw new InvalidParameterException(msg);
            }
            int detailLevel = paramsIn.readUnsignedShort();
            if (detailLevel != 1) {
                String msg = "Expected: 1, got: " + detailLevel;
                throw new InvalidParameterException(msg);
            }
            int receiveBufferLength = paramsIn.readUnsignedShort();
            Collection shares = request.getServer().enumShares();
            SmbOutput paramsOut = response.getParameters();
            paramsOut.writeShort(0);
            paramsOut.writeShort(0);
            paramsOut.writeShort(shares.size());
            paramsOut.writeShort(shares.size());
            SmbOutput dataOut = response.getData();
            SmbOutput buffer = new SmbOutput();
            buffer.setUnicode(request.isUnicode());
            int bufferOffset = shares.size() * 20;
            Iterator iter = shares.iterator();
            while (iter.hasNext()) {
                SmbShare share = (SmbShare)iter.next();
                dataOut.write(TransactionHandler.padString(share.getName(), 14));
                dataOut.writeShort(share.getType());
                dataOut.writeInt(bufferOffset);
                buffer.writeASCII(share.getDescription());
                bufferOffset += buffer.getLength();
            }
            dataOut.append(buffer);
        } else if (functionCode == 1) {
            String parameterDescriptor = paramsIn.readASCII();
            String returnDescriptor = paramsIn.readASCII();
            if (!parameterDescriptor.equals("zWrLh")) {
                String msg = "Expected: 'zWrLh', got: " + parameterDescriptor;
                throw new InvalidParameterException(msg);
            }
            if (!returnDescriptor.equals("B13BWz")) {
                String msg = "Expected: 'B13BWz', got: " + returnDescriptor;
                throw new InvalidParameterException(msg);
            }
            String name = paramsIn.readASCII();
            int detailLevel = paramsIn.readUnsignedShort();
            if (detailLevel != 1) {
                String msg = "Expected: 1, got: " + detailLevel;
                throw new InvalidParameterException(msg);
            }
            int receiveBufferLength = paramsIn.readUnsignedShort();
            SmbShare share = request.getServer().getShare(name);
            if (share == null) {
                String msg = "Object name not found: " + name;
                throw new ObjectNameNotFoundException(msg);
            }
            SmbOutput paramsOut = response.getParameters();
            paramsOut.writeShort(0);
            paramsOut.writeShort(0);
            SmbOutput dataOut = response.getData();
            SmbOutput buffer = new SmbOutput();
            buffer.setUnicode(request.isUnicode());
            dataOut.write(TransactionHandler.padString(share.getName(), 14));
            dataOut.writeShort(share.getType());
            dataOut.writeInt(20);
            buffer.writeASCII(share.getDescription());
            dataOut.append(buffer);
            paramsOut.writeShort(dataOut.getLength());
        } else {
            String msg = "Function code unknown: " + functionCode;
            throw new InvalidParameterException(msg);
        }
    }

    private static byte[] padString(String s, int size) {
        byte[] b = s.getBytes();
        int length = b.length < size ? b.length : size - 1;
        byte[] ret = new byte[size];
        System.arraycopy(b, 0, ret, 0, length);
        return ret;
    }
}

