/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;
import com.day.smb.server.SmbSession;
import com.day.smb.server.SmbTree;

class TreeConnectAndXHandler
extends SmbCommandHandler {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final int SEARCH_BITS = 1;
    private static final int SHARE_IS_IN_DFS = 2;

    TreeConnectAndXHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbInput paramsIn = request.getParameters();
        int flags = paramsIn.readUnsignedShort();
        int passwordLength = paramsIn.readUnsignedShort();
        SmbInput bufferIn = request.getData();
        byte[] buf = new byte[passwordLength];
        bufferIn.readFully(buf);
        String password = new String(buf);
        String path = bufferIn.readString();
        String service = bufferIn.readASCII();
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("TREE_CONNECT_ANDX[flags=" + flags + ",password=" + password + ",path=" + path + ",service=" + service + "]");
        }
        SmbSession smbSession = request.getSession();
        SmbTree smbTree = smbSession.connect(password, path, service);
        SmbOutput paramsOut = response.getParameters();
        paramsOut.writeShort(1);
        SmbOutput bufferOut = response.getData();
        bufferOut.writeASCII(smbTree.getService());
        bufferOut.writeString("NTFS");
        response.setTid(smbTree.getTid());
    }
}

