/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.SmbException;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;

class UnknownCommandHandler
extends SmbCommandHandler {
    public static final String SMB_COM_PREFIX = "SMB_COM_";
    public static final String TRANS_PREFIX = "TRANS_";
    public static final String TRANS2_PREFIX = "TRANS2_";
    public static final String NT_TRANSACT_PREFIX = "NT_TRANSACT_";
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private final byte[] unknownCommands = new byte[256];
    private final String prefix;

    public UnknownCommandHandler(String prefix) {
        this.prefix = prefix;
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        int command = request.getCommand();
        if (this.unknownCommands[command] == 0) {
            cmdLog.warn(this.prefix + "[0x" + Integer.toHexString(command) + "] unmapped.");
            this.unknownCommands[command] = 1;
        }
        response.setStatus(-1073741822);
    }
}

