/*
 * Decompiled with CFR 0.152.
 */
package com.day.smb.server;

import com.day.smb.InvalidParameterException;
import com.day.smb.SmbException;
import com.day.smb.SmbInput;
import com.day.smb.SmbOutput;
import com.day.smb.server.SmbCommandHandler;
import com.day.smb.server.SmbFile;
import com.day.smb.server.SmbRequest;
import com.day.smb.server.SmbResponse;

class WriteHandler
extends SmbCommandHandler {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    WriteHandler() {
    }

    public void handle(SmbRequest request, SmbResponse response) throws SmbException {
        SmbFile smbFile;
        SmbInput paramsIn = request.getParameters();
        int fid = paramsIn.readUnsignedShort();
        int count = paramsIn.readUnsignedShort();
        int offset = paramsIn.readInt();
        int remaining = paramsIn.readUnsignedShort();
        SmbInput dataIn = request.getData();
        int format = dataIn.readUnsignedByte();
        if (format != 1) {
            String msg = "Unexpected format identifier: " + format;
            throw new InvalidParameterException(msg);
        }
        int length = dataIn.readUnsignedShort();
        byte[] data = new byte[length];
        dataIn.readFully(data);
        if (cmdLog.isDebugEnabled()) {
            cmdLog.debug("WRITE[fid=" + fid + ",count=" + count + ",offset=" + offset + ",remaining=" + remaining + ",length=" + length + "]");
        }
        if ((smbFile = request.getTree().lookup(fid)).isDirectory()) {
            response.setStatus(-1073741638);
            return;
        }
        if (data.length == 0) {
            smbFile.setLength(offset);
        } else {
            smbFile.write(data, offset);
        }
        SmbOutput paramsOut = response.getParameters();
        paramsOut.writeShort(length);
    }
}

