/*
 * Decompiled with CFR 0.152.
 */
package com.day.commons.datasource.jdbcpool;

import com.day.commons.datasource.poolservice.DataSourcePoolProvider;
import java.util.Dictionary;
import javax.sql.DataSource;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcPoolService
implements DataSourcePoolProvider {
    private LogService log;
    private String name;
    private DataSource dataSource;
    public static final int DEFAULT_POOL_SIZE = 10;
    public static final int DEFAULT_MAX_WAIT_MSEC = 1000;
    public static final int MAX_WAIT_DONT_WAIT = 0;
    public static final int MAX_WAIT_BLOCK = -1;
    public static final String OSGI_PROPERTY_JDBC_DRIVER_CLASS = "jdbc.driver.class";
    public static final String OSGI_PROPERTY_JDBC_CONNECTION_URI = "jdbc.connection.uri";
    public static final String OSGI_PROPERTY_JDBC_USERNAME = "jdbc.username";
    public static final String OSGI_PROPERTY_JDBC_PASSWORD = "jdbc.password";
    public static final String OSGI_PROPERTY_JDBC_VALIDATION_QUERY = "jdbc.validation.query";
    public static final String OSGI_PROPERTY_DEFAULT_READ_ONLY = "default.readonly";
    public static final String OSGI_PROPERTY_DEFAULT_AUTO_COMMIT = "default.autocommit";
    public static final String OSGI_PROPERTY_POOL_SIZE = "pool.size";
    public static final String OSGI_PROPERTY_MAX_WAIT_MSEC = "pool.max.wait.msec";
    public static final String OSGI_PROPERTY_DATASOURCE_NAME = "datasource.name";

    public Object getDataSource(String name) {
        if (name.equals(this.name)) {
            return this.dataSource;
        }
        return null;
    }

    protected void activate(ComponentContext componentContext) throws Exception {
        if (this.name != null) {
            throw new IllegalStateException("Already activated with name=" + this.name);
        }
        Dictionary properties = componentContext.getProperties();
        String newName = (String)properties.get(OSGI_PROPERTY_DATASOURCE_NAME);
        if (newName == null || newName.trim().length() == 0) {
            throw new Exception("Missing configuration property datasource.name");
        }
        if (this.log != null) {
            this.log.log(3, "Configuring and activating data source with name=" + newName);
        }
        this.setupDataSource(newName, JdbcPoolService.createConfig(properties));
    }

    protected void deactivate(ComponentContext componentContext) throws Exception {
        if (this.log != null) {
            this.log.log(3, "deactivating data source with name=" + this.name);
        }
        this.name = null;
        this.dataSource = null;
    }

    void setupDataSource(String newName, DataSourceConfig cfg) throws ClassNotFoundException {
        if (this.name != null) {
            throw new IllegalStateException("Already configured with name '" + this.name + "'");
        }
        if (cfg.driverClassToLoad != null) {
            this.getClass().getClassLoader().loadClass(cfg.driverClassToLoad);
        }
        GenericObjectPool connectionPool = new GenericObjectPool(null);
        connectionPool.setMaxActive(cfg.poolSize);
        if (cfg.maxWaitMsec <= 0) {
            throw new IllegalArgumentException("For now, DataSourceConfig.maxWaitMsec must be >= 0");
        }
        connectionPool.setWhenExhaustedAction((byte)1);
        connectionPool.setMaxWait(cfg.maxWaitMsec);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(cfg.connectionURI, cfg.username, cfg.password);
        KeyedObjectPoolFactory kopf = null;
        new PoolableConnectionFactory(connectionFactory, connectionPool, kopf, cfg.validationQuery, cfg.defaultReadOnly, cfg.defaultAutoCommit);
        this.dataSource = new PoolingDataSource(connectionPool);
        if (this.log != null) {
            this.log.log(3, "Datasource configured, name=" + newName + ", connectionURI=" + cfg.connectionURI + ", default readonly=" + cfg.defaultReadOnly + ", default autocommit=" + cfg.defaultAutoCommit + ", validation query=" + cfg.validationQuery);
        }
        this.name = newName;
    }

    protected static String nullIfEmpty(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return str;
    }

    static DataSourceConfig createConfig(Dictionary<String, Object> params) {
        DataSourceConfig result = new DataSourceConfig();
        result.driverClassToLoad = (String)params.get(OSGI_PROPERTY_JDBC_DRIVER_CLASS);
        result.connectionURI = (String)params.get(OSGI_PROPERTY_JDBC_CONNECTION_URI);
        result.username = JdbcPoolService.nullIfEmpty((String)params.get(OSGI_PROPERTY_JDBC_USERNAME));
        result.password = JdbcPoolService.nullIfEmpty((String)params.get(OSGI_PROPERTY_JDBC_PASSWORD));
        result.validationQuery = JdbcPoolService.nullIfEmpty((String)params.get(OSGI_PROPERTY_JDBC_VALIDATION_QUERY));
        result.defaultReadOnly = (Boolean)params.get(OSGI_PROPERTY_DEFAULT_READ_ONLY);
        result.defaultAutoCommit = (Boolean)params.get(OSGI_PROPERTY_DEFAULT_AUTO_COMMIT);
        result.poolSize = (Integer)params.get(OSGI_PROPERTY_POOL_SIZE);
        result.maxWaitMsec = (Integer)params.get(OSGI_PROPERTY_MAX_WAIT_MSEC);
        return result;
    }

    protected void bindLog(LogService logService) {
        this.log = logService;
    }

    protected void unbindLog(LogService logService) {
        if (this.log == logService) {
            this.log = null;
        }
    }

    static class DataSourceConfig {
        String driverClassToLoad;
        String connectionURI;
        String username;
        String password;
        String validationQuery;
        boolean defaultReadOnly;
        boolean defaultAutoCommit;
        int poolSize = 10;
        int maxWaitMsec = 1000;

        DataSourceConfig() {
        }
    }
}

