/*
 * Decompiled with CFR 0.152.
 */
package com.day.commons.datasource.poolservice.impl;

import com.day.commons.datasource.poolservice.DataSourceNotFoundException;
import com.day.commons.datasource.poolservice.DataSourcePool;
import com.day.commons.datasource.poolservice.DataSourcePoolProvider;
import com.day.commons.datasource.poolservice.TypeNotAvailableException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourcePoolImpl
implements DataSourcePool {
    private ServiceTracker tracker;
    private LogService log;

    @Override
    public <AdapterType> AdapterType getDataSource(String name, Class<AdapterType> desiredType) throws DataSourceNotFoundException, TypeNotAvailableException {
        Object result = this.getDataSource(name);
        TypeNotAvailableException e = TypeNotAvailableException.checkCompatible(result, desiredType, "DataSource with name '" + name + "'");
        if (e != null) {
            throw e;
        }
        return (AdapterType)result;
    }

    @Override
    public Object getDataSource(String name) throws DataSourceNotFoundException {
        Object result = null;
        int nProviders = 0;
        Object[] svc = this.getProviders();
        if (name != null && svc != null) {
            nProviders = svc.length;
            for (Object o : svc) {
                DataSourcePoolProvider provider = (DataSourcePoolProvider)o;
                if (this.log != null) {
                    this.log.log(4, "Asking provider " + provider.getClass().getName() + " for data source " + name);
                }
                if ((result = provider.getDataSource(name)) != null) break;
            }
        }
        if (this.log != null) {
            this.log.log(4, "getDataSource(" + name + ")=" + result);
        }
        if (result == null) {
            throw new DataSourceNotFoundException(name, nProviders);
        }
        return result;
    }

    protected Object[] getProviders() {
        if (this.tracker == null) {
            throw new IllegalStateException("ServiceTracker not initialized");
        }
        return this.tracker.getServices();
    }

    protected synchronized void activate(ComponentContext context) {
        this.tracker = new ServiceTracker(context.getBundleContext(), DataSourcePoolProvider.class.getName(), null);
        this.tracker.open();
    }

    protected synchronized void deactivate(ComponentContext context) {
        this.tracker.close();
        this.tracker = null;
    }

    protected void bindLog(LogService logService) {
        this.log = logService;
    }

    protected void unbindLog(LogService logService) {
        if (this.log == logService) {
            this.log = null;
        }
    }
}

