/*
 * Decompiled with CFR 0.152.
 */
package com.day.commons.datasource.poolservice.impl;

import com.day.commons.datasource.poolservice.DataSourceNotFoundException;
import com.day.commons.datasource.poolservice.DataSourcePool;
import com.day.commons.datasource.poolservice.DataSourcePoolProvider;
import com.day.commons.datasource.poolservice.TypeNotAvailableException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourcePoolImpl
implements DataSourcePool {
    private DataSourcePoolProvider[] dataSourcePoolProviders;
    private Set<String> jndiNames = new HashSet<String>();
    private LogService log;
    private InitialContextFactory contextFactory;
    private Context context;

    @Override
    public <AdapterType> AdapterType getDataSource(String name, Class<AdapterType> desiredType) throws DataSourceNotFoundException, TypeNotAvailableException {
        Object result = this.getDataSource(name);
        TypeNotAvailableException e = TypeNotAvailableException.checkCompatible(result, desiredType, "DataSource with name '" + name + "'");
        if (e != null) {
            throw e;
        }
        return (AdapterType)result;
    }

    @Override
    public Object getDataSource(String name) throws DataSourceNotFoundException {
        Object result = null;
        int nProviders = 0;
        DataSourcePoolProvider[] svc = this.getProviders();
        if (name != null && svc != null) {
            nProviders = svc.length;
            for (DataSourcePoolProvider provider : svc) {
                if (this.log != null) {
                    this.log.log(4, "Asking provider " + provider.getClass().getName() + " for data source " + name);
                }
                if ((result = provider.getDataSource(name)) != null) break;
            }
        }
        if (this.log != null) {
            this.log.log(4, "getDataSource(" + name + ")=" + result);
        }
        if (result == null) {
            throw new DataSourceNotFoundException(name, nProviders);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllJndiDataSourceNames() {
        DataSourcePoolImpl dataSourcePoolImpl = this;
        synchronized (dataSourcePoolImpl) {
            return new HashSet<String>(this.jndiNames);
        }
    }

    DataSourcePoolProvider[] getProviders() {
        return this.dataSourcePoolProviders;
    }

    synchronized void bindInitialContextFactory(InitialContextFactory initialContextFactory) {
        if (this.contextFactory != null) {
            this.unbindInitialContextFactory(this.contextFactory);
        }
        this.contextFactory = initialContextFactory;
        if (this.dataSourcePoolProviders != null) {
            for (DataSourcePoolProvider dataSourcePoolProvider : this.dataSourcePoolProviders) {
                this.jndiBind(dataSourcePoolProvider);
            }
        }
    }

    synchronized void unbindInitialContextFactory(InitialContextFactory initialContextFactory) {
        if (this.contextFactory == initialContextFactory) {
            if (this.dataSourcePoolProviders != null) {
                for (DataSourcePoolProvider dataSourcePoolProvider : this.dataSourcePoolProviders) {
                    this.jndiUnbind(dataSourcePoolProvider);
                }
            }
            this.contextFactory = null;
            if (this.context != null) {
                try {
                    this.context.close();
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                this.context = null;
            }
        }
    }

    protected synchronized void bindDataSourcePoolProvider(DataSourcePoolProvider dataSourcePoolProvider) {
        HashSet<DataSourcePoolProvider> providerSet = new HashSet<DataSourcePoolProvider>();
        if (this.dataSourcePoolProviders != null) {
            providerSet.addAll(Arrays.asList(this.dataSourcePoolProviders));
        }
        providerSet.add(dataSourcePoolProvider);
        this.dataSourcePoolProviders = providerSet.toArray(new DataSourcePoolProvider[providerSet.size()]);
        this.jndiBind(dataSourcePoolProvider);
    }

    protected synchronized void unbindDataSourcePoolProvider(DataSourcePoolProvider dataSourcePoolProvider) {
        this.jndiUnbind(dataSourcePoolProvider);
        HashSet<DataSourcePoolProvider> providerSet = new HashSet<DataSourcePoolProvider>();
        if (this.dataSourcePoolProviders != null) {
            providerSet.addAll(Arrays.asList(this.dataSourcePoolProviders));
        }
        providerSet.remove(dataSourcePoolProvider);
        this.dataSourcePoolProviders = providerSet.toArray(new DataSourcePoolProvider[providerSet.size()]);
    }

    private void jndiBind(DataSourcePoolProvider dataSourcePoolProvider) {
        Context context = this.getContext();
        if (context != null) {
            String[] names;
            for (String name : names = dataSourcePoolProvider.getNames()) {
                if (name.indexOf(58) <= 0) continue;
                try {
                    context.bind(name, dataSourcePoolProvider.getDataSource(name));
                    this.jndiNames.add(name);
                    this.log(3, "Registered datasource as " + name, null);
                }
                catch (NamingException e) {
                    this.log(2, "Unable to bind data source " + name, e);
                }
            }
        }
    }

    private void jndiUnbind(DataSourcePoolProvider dataSourcePoolProvider) {
        Context context = this.getContext();
        if (context != null) {
            String[] names;
            for (String name : names = dataSourcePoolProvider.getNames()) {
                if (name.indexOf(58) <= 0) continue;
                try {
                    this.jndiNames.remove(name);
                    context.unbind(name);
                    this.log(3, "Unregistered datasource as " + name, null);
                }
                catch (NamingException e) {
                    this.log(2, "Unable to unbind data source " + name, e);
                }
            }
        }
    }

    private Context getContext() {
        InitialContextFactory contextFactory;
        if (this.context == null && (contextFactory = this.contextFactory) != null) {
            try {
                this.context = contextFactory.getInitialContext(null);
            }
            catch (NamingException ne) {
                this.log(1, "getContext: Cannot get Context from " + contextFactory, ne);
            }
        }
        return this.context;
    }

    private void log(int level, String message, Throwable t) {
        LogService log = this.log;
        if (log != null) {
            log.log(level, message, t);
        }
    }

    protected void bindLog(LogService logService) {
        this.log = logService;
    }

    protected void unbindLog(LogService logService) {
        if (this.log == logService) {
            this.log = null;
        }
    }
}

