/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.blog.antispam.impl;

import com.day.cq.collab.blog.antispam.AkismetService;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Component(metatype=true, label="Day CQ Antispam", description="Akismet configuration")
@Service
@Property(name="service.description", value={"Akismet Spam Check for blog comments"})
public class AkismetServiceImpl
implements AkismetService {
    private Log logger = LogFactory.getLog(AkismetServiceImpl.class);
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String USER_AGENT_VALUE = "Day Communique 5";
    private static final String API_PARAMETER_KEY = "key";
    private static final String API_PARAMETER_BLOG = "blog";
    private static final String API_PARAMETER_USER_IP = "user_ip";
    private static final String API_PARAMETER_USER_AGENT = "user_agent";
    private static final String API_PARAMETER_REFERRER = "referrer";
    private static final String API_PARAMETER_PERMALINK = "permalink";
    private static final String API_PARAMETER_COMMENT_TYPE = "comment_type";
    private static final String API_PARAMETER_COMMENT_AUTHOR = "comment_author";
    private static final String API_PARAMETER_COMMENT_AUTHOR_EMAIL = "comment_author_email";
    private static final String API_PARAMETER_COMMENT_AUTHOR_URL = "comment_author_url";
    private static final String API_PARAMETER_COMMENT_CONTENT = "comment_content";
    private static final String VALID_RESPONSE = "valid";
    private static final String FALSE_RESPONSE = "false";
    public static final String COMMENT_TYPE_BLANK = "";
    public static final String COMMENT_TYPE_COMMENT = "comment";
    public static final String COMMENT_TYPE_TRACKBACK = "trackback";
    public static final String COMMENT_TYPE_PINGBACK = "pingback";
    private HttpClient httpClient;
    private String apiKey;
    private String blog;
    private boolean verifiedKey = false;
    private String providerUrlFragment;
    @Property
    public static final String PARAM_API_KEY = "akismet.service.api.key";
    @Property
    public static final String PARAM_REGISTERED_URL = "akismet.service.registered.url";
    @Property(intValue={0}, options={@PropertyOption(name="0", value="Akismet"), @PropertyOption(name="1", value="Typepad")})
    public static final String PARAM_SERVICE_PROVIDER = "akismet.service.provider";
    private static final int SERVICE_PROVIDER_TYPE_AKISMET = 0;
    private static final int SERVICE_PROVIDER_TYPE_TYPEPAD = 1;

    public AkismetServiceImpl() {
    }

    AkismetServiceImpl(BundleContext bundleContext, Dictionary<String, Object> configuration) {
        this.setup(bundleContext, configuration);
    }

    void setup(BundleContext bundleContext, Dictionary<String, Object> configuration) {
        Object provider;
        Object registered;
        Object key = configuration.get(PARAM_API_KEY);
        if (key != null) {
            this.apiKey = key.toString();
        }
        if ((registered = configuration.get(PARAM_REGISTERED_URL)) != null) {
            this.blog = registered.toString();
        }
        if ((provider = configuration.get(PARAM_SERVICE_PROVIDER)) != null) {
            int p = (Integer)provider;
            switch (p) {
                case 1: {
                    this.providerUrlFragment = "api.antispam.typepad.com/1.1/";
                    break;
                }
                default: {
                    this.providerUrlFragment = "rest.akismet.com/1.1/";
                }
            }
        }
        if (this.providerUrlFragment != null && this.apiKey != null && this.blog != null && this.providerUrlFragment.length() > 0 && this.apiKey.length() > 0 && this.blog.length() > 0) {
            this.logger.info((Object)("verifying Akismet API key with blog=" + this.blog + " , key=" + this.apiKey + " and urlFragment=" + this.providerUrlFragment));
            this.logger.info((Object)("Akismet API key verification result is " + this.verifyAPIKey()));
        }
    }

    void shutdown() {
        this.apiKey = null;
    }

    protected void activate(ComponentContext context) {
        this.httpClient = new HttpClient();
        HttpClientParams httpClientParams = new HttpClientParams();
        DefaultHttpMethodRetryHandler defaultHttpMethodRetryHandler = new DefaultHttpMethodRetryHandler(0, false);
        httpClientParams.setParameter(USER_AGENT_HEADER, (Object)USER_AGENT_VALUE);
        httpClientParams.setParameter("http.method.retry-handler", (Object)defaultHttpMethodRetryHandler);
        this.httpClient.setParams(httpClientParams);
        this.setup(context.getBundleContext(), context.getProperties());
    }

    protected void deactivate(ComponentContext context) {
        this.shutdown();
    }

    @Override
    public boolean isVerifiedKey() {
        return this.verifiedKey;
    }

    @Override
    public void setProxyConfiguration(String proxyHost, int proxyPort) {
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setProxy(proxyHost, proxyPort);
        this.httpClient.setHostConfiguration(hostConfiguration);
    }

    private boolean checkNullOrBlank(String input) {
        return input == null || COMMENT_TYPE_BLANK.equals(input);
    }

    @Override
    public void setProxyAuthenticationConfiguration(String proxyUsername, String proxyPassword) {
        this.httpClient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
    }

    @Override
    public boolean verifyAPIKey() {
        boolean callResult = true;
        PostMethod post = new PostMethod("http://" + this.providerUrlFragment + "verify-key");
        post.addParameter(API_PARAMETER_KEY, this.apiKey);
        if (this.blog != null) {
            post.addParameter(API_PARAMETER_BLOG, this.blog);
        }
        try {
            this.httpClient.executeMethod((HttpMethod)post);
            String result = post.getResponseBodyAsString();
            this.logger.info((Object)("Akismet response: " + result));
            if (!this.checkNullOrBlank(result) && !VALID_RESPONSE.equals(result)) {
                callResult = false;
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            callResult = false;
        }
        this.verifiedKey = callResult;
        return callResult;
    }

    private boolean akismetCall(String function, String ipAddress, String userAgent, String referrer, String permalink, String commentType, String author, String authorEmail, String authorURL, String commentContent, Map other) {
        boolean callResult = false;
        String akismetURL = "http://" + this.apiKey + "." + this.providerUrlFragment + function;
        this.logger.debug((Object)("Akismet url: " + akismetURL));
        PostMethod post = new PostMethod(akismetURL);
        post.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        if (this.blog != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_BLOG, this.blog));
        }
        if (ipAddress != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_USER_IP, ipAddress));
        } else {
            post.addParameter(new NameValuePair(API_PARAMETER_USER_IP, COMMENT_TYPE_BLANK));
        }
        if (userAgent != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_USER_AGENT, userAgent));
        }
        if (referrer != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_REFERRER, referrer));
        }
        if (permalink != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_PERMALINK, permalink));
        }
        if (commentType != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_COMMENT_TYPE, commentType));
        }
        if (author != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_COMMENT_AUTHOR, author));
        }
        if (authorEmail != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_COMMENT_AUTHOR_EMAIL, authorEmail));
        }
        if (authorURL != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_COMMENT_AUTHOR_URL, authorURL));
        }
        if (commentContent != null) {
            post.addParameter(new NameValuePair(API_PARAMETER_COMMENT_CONTENT, commentContent));
        }
        if (other != null && other.size() > 0) {
            for (String key : other.keySet()) {
                if (key == null || other.get(key) == null) continue;
                post.addParameter(new NameValuePair(key, other.get(key).toString()));
            }
        }
        try {
            this.logger.debug((Object)"Akismet: starting call");
            this.httpClient.executeMethod((HttpMethod)post);
            String result = post.getResponseBodyAsString();
            this.logger.debug((Object)("Akismet response: " + result));
            if (!this.checkNullOrBlank(result) && !FALSE_RESPONSE.equals(result = result.trim())) {
                callResult = true;
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            callResult = true;
        }
        return callResult;
    }

    @Override
    public boolean commentCheck(String ipAddress, String userAgent, String referrer, String permalink, String commentType, String author, String authorEmail, String authorURL, String commentContent, Map other) {
        return this.akismetCall("comment-check", ipAddress, userAgent, referrer, permalink, commentType, author, authorEmail, authorURL, commentContent, other);
    }

    @Override
    public void submitSpam(String ipAddress, String userAgent, String referrer, String permalink, String commentType, String author, String authorEmail, String authorURL, String commentContent, Map other) {
        this.akismetCall("submit-spam", ipAddress, userAgent, referrer, permalink, commentType, author, authorEmail, authorURL, commentContent, other);
    }

    @Override
    public void submitHam(String ipAddress, String userAgent, String referrer, String permalink, String commentType, String author, String authorEmail, String authorURL, String commentContent, Map other) {
        this.akismetCall("submit-ham", ipAddress, userAgent, referrer, permalink, commentType, author, authorEmail, authorURL, commentContent, other);
    }
}

