/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.blog.impl;

import com.day.cq.collab.blog.Blog;
import com.day.cq.collab.blog.BlogEntry;
import com.day.cq.collab.blog.BlogException;
import com.day.cq.collab.blog.BlogManager;
import com.day.cq.collab.blog.impl.BlogImpl;
import com.day.cq.collab.commons.CollabException;
import com.day.cq.collab.commons.Comment;
import com.day.cq.collab.commons.CommentException;
import com.day.cq.collab.commons.CommentSystem;
import com.day.cq.commons.Externalizer;
import com.day.cq.i18n.I18n;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.text.Text;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BlogEntryImpl
implements BlogEntry {
    public static final Logger log = LoggerFactory.getLogger(BlogEntry.class);
    private String id;
    private boolean dirty;
    private SlingHttpServletRequest request;
    private Resource resource;
    private Page page;
    private Blog blog;
    private BlogManager manager;
    private List<String> attachments = null;
    private String title;
    private String text;
    private String author;
    private Date date;
    private Tag[] tags;
    private CommentSystem cs;
    private Externalizer externalizer;

    public BlogEntryImpl(Resource res) throws BlogException {
        this(null, res);
    }

    public BlogEntryImpl(SlingHttpServletRequest req, Resource res) throws BlogException {
        this(req, BlogImpl.findPage(res), null);
    }

    public BlogEntryImpl(SlingHttpServletRequest req, Page p, BlogManager bm) throws BlogException {
        this(req, p, bm, null);
    }

    public BlogEntryImpl(SlingHttpServletRequest req, Page p, BlogManager bm, ResourceBundle resourceBundle) throws BlogException {
        if (p == null) {
            throw new BlogException("page does not exist");
        }
        this.page = p;
        this.request = req;
        this.resource = this.page.getContentResource();
        this.manager = bm != null ? bm : (BlogManager)this.resource.getResourceResolver().adaptTo(BlogManager.class);
        ValueMap properties = this.page.getProperties();
        this.id = (String)properties.get("id", null);
        this.title = this.page.getTitle();
        if (this.title == null) {
            this.title = this.page.getName();
        }
        this.text = (String)properties.get("text", (Object)"...");
        Calendar cal = (Calendar)properties.get("published", properties.get("cq:lastReplicated", properties.get("cq:lastModified", Calendar.class)));
        if (cal == null) {
            cal = Calendar.getInstance();
            try {
                cal.setTime(new Date(this.page.getContentResource().getResourceMetadata().getCreationTime()));
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        this.date = cal.getTime();
        this.author = (String)properties.get("author", null);
        this.tags = this.page.getTags();
        Arrays.sort(this.tags, new Comparator<Tag>(){

            @Override
            public int compare(Tag tag1, Tag tag2) {
                return tag1.getTitle().compareTo(tag2.getTitle());
            }
        });
        if (this.author == null) {
            this.author = (String)properties.get("cq:lastReplicatedBy", properties.get("cq:lastModifiedBy", (Object)I18n.get((ResourceBundle)resourceBundle, (String)"Anonymous")));
        }
        try {
            Node textNode = (Node)this.page.getContentResource("par/entry").adaptTo(Node.class);
            if (textNode.hasProperty("text")) {
                this.text = textNode.getProperty("text").getString();
            }
        }
        catch (Exception e) {
            log.warn("no blog entry text found", (Throwable)e);
        }
    }

    private Externalizer getExternalizer() {
        if (this.externalizer == null) {
            this.externalizer = (Externalizer)this.resource.getResourceResolver().adaptTo(Externalizer.class);
        }
        return this.externalizer;
    }

    private String externalize(String path) {
        if (this.request != null) {
            return this.getExternalizer().absoluteLink(this.request, this.request.getScheme(), path);
        }
        return this.getExternalizer().absoluteLink(this.resource.getResourceResolver(), "http", path);
    }

    @Override
    public Blog getBlog() {
        if (this.blog == null) {
            this.blog = this.manager.getBlog(this.page.getParent(3).getPath());
        }
        return this.blog;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public String getId() {
        return this.id != null ? this.id : this.getFullUrl();
    }

    @Override
    public void setId(String id) {
        if (this.id != null) {
            throw new IllegalStateException("ID of blog entry " + this.getPage().getPath() + " already set");
        }
        try {
            ((Node)this.page.getContentResource().adaptTo(Node.class)).setProperty("id", id);
            this.id = id;
            this.dirty = true;
        }
        catch (Exception e) {
            log.error("failed to set ID", (Throwable)e);
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        try {
            ((Node)this.page.getContentResource().adaptTo(Node.class)).setProperty("jcr:title", title);
            this.title = title;
            this.dirty = true;
        }
        catch (Exception e) {
            log.error("failed to set title", (Throwable)e);
        }
    }

    @Override
    public Resource getContentResource() {
        return this.page.getContentResource(Text.getRelativeParent((String)"par/entry", (int)1));
    }

    @Override
    public String getText() {
        return this.text != null ? this.text : "";
    }

    @Override
    public void setText(String text) {
        try {
            ((Node)this.page.getContentResource("par/entry").adaptTo(Node.class)).setProperty("text", text);
            this.text = text;
            this.dirty = true;
        }
        catch (Exception e) {
            log.error("failed to set text", (Throwable)e);
        }
    }

    @Override
    public Tag[] getTags() {
        return this.tags;
    }

    @Override
    public void setTags(Tag[] tags) {
        if (tags != null) {
            TagManager tagManager = (TagManager)this.page.getContentResource().getResourceResolver().adaptTo(TagManager.class);
            tagManager.setTags(this.page.getContentResource(), tags);
            this.tags = tags;
        }
    }

    @Override
    public String getTagsAsString() {
        StringBuffer sb = new StringBuffer();
        Tag[] tags = this.getTags();
        if (tags.length > 0) {
            for (int i = 0; i < tags.length; ++i) {
                sb.append(tags[i].getName());
                if (i >= tags.length - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    @Override
    public String getTagsAsHTML() {
        return this.getTagsAsHTML(null);
    }

    @Override
    public String getTagsAsHTML(ResourceBundle resourceBundle) {
        StringBuffer sb = new StringBuffer();
        Tag[] tags = this.getTags();
        I18n i18n = new I18n(resourceBundle);
        if (tags.length > 0) {
            for (int i = 0; i < tags.length; ++i) {
                if (i > 0) {
                    if (i + 1 == tags.length) {
                        sb.append(" ").append(i18n.get("and")).append(" ");
                    } else {
                        sb.append(", ");
                    }
                }
                sb.append(this.getBlog().getTagAsHTML(tags[i], resourceBundle));
            }
        }
        return sb.toString();
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(String author) {
        if (!this.getAuthor().equals(author)) {
            try {
                ((Node)this.page.getContentResource().adaptTo(Node.class)).setProperty("author", author);
                this.author = author;
                this.dirty = true;
            }
            catch (Exception e) {
                log.error("failed to set author", (Throwable)e);
            }
        }
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            ((Node)this.page.getContentResource().adaptTo(Node.class)).setProperty("published", cal);
            this.date = date;
            this.dirty = true;
        }
        catch (Exception e) {
            log.error("failed to set date", (Throwable)e);
        }
    }

    @Override
    public String getUrl() {
        return this.page.getPath() + ".html";
    }

    @Override
    public String getFullUrl() {
        return this.externalize(this.getUrl());
    }

    @Override
    public String getFeedUrl() {
        return this.externalize(this.page.getPath() + "/jcr:content.feed");
    }

    @Override
    public String getFeedUrl(boolean absolute) {
        if (absolute) {
            return this.externalize(this.page.getPath() + "/jcr:content.feed");
        }
        return this.page.getPath() + "/jcr:content.feed";
    }

    @Override
    public String getTrackBackUrl() {
        return this.page.getPath() + ".trackback.html";
    }

    @Override
    public String getEditUrl(SlingHttpServletRequest request) {
        String editUrl;
        if (WCMMode.fromRequest((ServletRequest)request) == WCMMode.EDIT) {
            editUrl = this.getUrl();
        } else {
            editUrl = this.externalize("/collabauthor" + this.getUrl());
            if (editUrl.startsWith("/collabauthor")) {
                return null;
            }
        }
        return editUrl + "?" + "blog" + "=" + "edit";
    }

    @Override
    public boolean isPage() {
        return this.page.getParent().getParent().getName().equalsIgnoreCase("unlisted");
    }

    @Override
    public boolean isDraft() {
        return this.page.getParent().getParent().getName().equalsIgnoreCase("drafts");
    }

    @Override
    public boolean hasTag(String path) {
        for (Tag tag : this.getTags()) {
            if (!tag.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAttachments() {
        return this.attachments != null && this.attachments.size() > 0;
    }

    @Override
    public List<String> getAttachments() {
        return this.attachments;
    }

    @Override
    public boolean hasComments() {
        this.initCommentSystem();
        try {
            return this.cs.hasComments();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int countComments() {
        this.initCommentSystem();
        try {
            return this.cs.countComments();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public List<Comment> getComments() {
        this.initCommentSystem();
        try {
            return this.cs.getAllComments();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Comment addComment(String text, String author) throws BlogException {
        this.initCommentSystem();
        try {
            Comment c = this.cs.addComment(text, author);
            this.dirty = true;
            return c;
        }
        catch (Exception e) {
            log.error("failed to add comment", (Throwable)e);
            return null;
        }
    }

    @Override
    public void addTrackback(String title, String excerpt, String url, String blogName, String ip) throws BlogException {
        ResourceResolver resolver = this.resource.getResourceResolver();
        String rootPath = Text.getRelativeParent((String)this.cs.getRootPath(), (int)1) + "/" + "alt/trackback";
        Resource root = resolver.resolve(rootPath);
        String ugcPagePath = "/content/usergenerated" + this.page.getPath();
        if (ResourceUtil.isNonExistingResource((Resource)root)) {
            if (resolver.getResource(ugcPagePath) == null) {
                try {
                    this.manager.createPage(ugcPagePath, null, null, null);
                }
                catch (CollabException ce) {
                    throw new BlogException("failed to prepare user generated content", ce);
                }
            }
            try {
                Node parentNode = (Node)resolver.getResource(ugcPagePath + "/" + "jcr:content").adaptTo(Node.class);
                parentNode.addNode(Text.getName((String)rootPath), "nt:unstructured");
            }
            catch (RepositoryException re) {
                throw new CommentException("failed to prepare user generated content", (Throwable)re);
            }
        }
        try {
            Node tb = this.manager.createNode(rootPath + "/" + System.currentTimeMillis(), "cq:Trackback");
            if (title != null) {
                tb.setProperty("jcr:title", title);
            }
            if (excerpt != null) {
                tb.setProperty("excerpt", excerpt);
            }
            if (url != null) {
                tb.setProperty("url", url);
            }
            if (blogName != null) {
                tb.setProperty("blogName", blogName);
            }
            if (ip != null) {
                tb.setProperty("ip", ip);
            }
            tb.setProperty("cq:distribute", true);
            tb.setProperty("sling:resourceType", "collab/blog/components/trackbacks");
            Node content = (Node)resolver.getResource(Text.getRelativeParent((String)rootPath, (int)1)).adaptTo(Node.class);
            content.setProperty("cq:lastModified", Calendar.getInstance());
            content.setProperty("cq:lastModifiedBy", content.getSession().getUserID());
            this.dirty = true;
        }
        catch (Exception e) {
            throw new BlogException("failed to create trackback", e);
        }
    }

    @Override
    public boolean isModified() {
        return this.dirty;
    }

    @Override
    public void save() throws BlogException {
        if (this.dirty) {
            try {
                this.manager.save();
                this.dirty = false;
            }
            catch (CollabException ce) {
                throw new BlogException(ce);
            }
        }
    }

    private void initCommentSystem() {
        if (this.cs == null) {
            try {
                Resource commentsResource = this.resource.getResourceResolver().resolve(this.page.getPath() + "/" + "jcr:content" + "/" + "alt/comments");
                this.cs = (CommentSystem)commentsResource.adaptTo(CommentSystem.class);
            }
            catch (Exception e) {
                log.warn("unable to load comments for blog entry " + this.page.getPath(), (Throwable)e);
            }
        }
    }
}

