/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.blog.impl;

import com.day.cq.collab.blog.Blog;
import com.day.cq.collab.blog.BlogArchive;
import com.day.cq.collab.blog.BlogEntry;
import com.day.cq.collab.blog.BlogEntryDateComparator;
import com.day.cq.collab.blog.BlogEntryFilter;
import com.day.cq.collab.blog.BlogException;
import com.day.cq.collab.blog.BlogManager;
import com.day.cq.collab.blog.impl.BlogEntryImpl;
import com.day.cq.collab.blog.impl.BlogSuffixImpl;
import com.day.cq.collab.blog.impl.TimelineEntryFilter;
import com.day.cq.collab.commons.CollabException;
import com.day.cq.commons.Externalizer;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.i18n.I18n;
import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.Component;
import com.day.text.Text;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BlogImpl
implements Blog {
    public static final Logger log = LoggerFactory.getLogger(Blog.class);
    private boolean dirty;
    private Resource resource;
    private SlingHttpServletRequest request;
    private Page page;
    private List<BlogEntry> entries;
    private BlogEntry entry;
    private BlogManager manager;
    private BlogArchive archive;
    private Map<String, Tag> tags;
    private Map<String, Integer> tagCounts;
    private BlogEntryFilter timelineEntryFilter;
    private Externalizer externalizer;

    public BlogImpl(Resource res) throws BlogException {
        this(null, res);
    }

    public BlogImpl(SlingHttpServletRequest req, Resource res) throws BlogException {
        this.request = req;
        Resource resource = this.resource = res != null ? res : req.getResource();
        if ("sling:nonexisting".equals(this.resource.getResourceType())) {
            throw new BlogException("resource does not exist");
        }
        this.manager = (BlogManager)this.resource.getResourceResolver().adaptTo(BlogManager.class);
        this.page = BlogImpl.findPage(this.resource);
        if (this.page.getContentResource("par/entry") != null) {
            this.entry = new BlogEntryImpl(this.request, this.resource);
            this.page = this.page.getParent(3);
        }
        this.timelineEntryFilter = new TimelineEntryFilter();
    }

    private Externalizer getExternalizer() {
        if (this.externalizer == null) {
            this.externalizer = (Externalizer)this.resource.getResourceResolver().adaptTo(Externalizer.class);
        }
        return this.externalizer;
    }

    private String externalize(String path) {
        if (this.request != null) {
            return this.getExternalizer().absoluteLink(this.request, this.request.getScheme(), path);
        }
        return this.getExternalizer().absoluteLink(this.resource.getResourceResolver(), "http", path);
    }

    @Override
    public List<BlogEntry> getEntries() {
        this.initEntries();
        ArrayList<BlogEntry> filteredEntries = new ArrayList<BlogEntry>();
        for (BlogEntry entry : this.entries) {
            if (!this.timelineEntryFilter.pass(entry)) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries;
    }

    @Override
    public List<BlogEntry> getEntries(BlogEntryFilter filter) {
        ArrayList<BlogEntryFilter> filters = new ArrayList<BlogEntryFilter>();
        filters.add(filter);
        return this.getEntries(filters);
    }

    @Override
    public List<BlogEntry> getEntries(List<BlogEntryFilter> filters) {
        ArrayList<BlogEntry> entries = new ArrayList<BlogEntry>();
        block0: for (BlogEntry entry : this.getEntries()) {
            for (BlogEntryFilter filter : filters) {
                if (!filter.pass(entry)) continue;
                entries.add(entry);
                continue block0;
            }
        }
        return entries;
    }

    @Override
    public List<BlogEntry> getPages() {
        this.initEntries();
        ArrayList<BlogEntry> pages = new ArrayList<BlogEntry>();
        for (BlogEntry entry : this.entries) {
            if (this.timelineEntryFilter.pass(entry)) continue;
            pages.add(entry);
        }
        return pages;
    }

    @Override
    public String getPagesAsHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<ul>");
        for (BlogEntry page : this.getPages()) {
            sb.append("<li>");
            sb.append("<a href=\"");
            sb.append(page.getUrl());
            sb.append("\"");
            sb.append(" title=\"");
            sb.append(page.getTitle());
            sb.append("\">");
            sb.append(page.getTitle());
            sb.append("</a>");
            sb.append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    @Override
    public BlogEntry addEntry(String title, String text, Date date) throws BlogException {
        Date archiveDate = date != null ? date : new Date();
        StringBuffer parent = new StringBuffer(this.page.getPath());
        parent.append("/");
        parent.append(new SimpleDateFormat("yyyy").format(archiveDate));
        parent.append("/");
        parent.append(new SimpleDateFormat("MM").format(archiveDate));
        try {
            BlogEntry entry = this.addEntry(parent.toString(), title, text, false);
            if (date != null) {
                entry.setDate(date);
            }
            return entry;
        }
        catch (Exception e) {
            throw new BlogException("unable to create blog page: " + title, e);
        }
    }

    @Override
    public BlogEntry addPage(String title, String text) throws BlogException {
        String parentPath = this.page.getPath() + "/unlisted/pages";
        try {
            return this.addEntry(parentPath, title, text, true);
        }
        catch (Exception e) {
            throw new BlogException("unable to create blog page: " + title, e);
        }
    }

    @Override
    public Tag[] getTags() {
        this.initTags();
        Tag[] sortedTags = this.tags.values().toArray(new Tag[this.tags.size()]);
        Arrays.sort(sortedTags, new Comparator<Tag>(){

            @Override
            public int compare(Tag tag1, Tag tag2) {
                return tag1.getTitle().compareTo(tag2.getTitle());
            }
        });
        return sortedTags;
    }

    @Override
    public String[] getAuthors() {
        ArrayList<String> authors = new ArrayList<String>();
        for (BlogEntry entry : this.getEntries()) {
            if (authors.contains(entry.getAuthor())) continue;
            authors.add(entry.getAuthor());
        }
        Collections.sort(authors);
        return authors.toArray(new String[authors.size()]);
    }

    @Override
    public String getTagAsHTML(Tag tag) {
        return this.getTagAsHTML(tag, null);
    }

    @Override
    public String getTagAsHTML(Tag tag, ResourceBundle resourceBundle) {
        StringBuffer sb = new StringBuffer();
        sb.append("<a href=\"");
        sb.append(this.getUrl());
        sb.append(new BlogSuffixImpl("category", tag.getPath()).toString());
        sb.append("\"");
        sb.append(" title=\"");
        sb.append(I18n.get((ResourceBundle)resourceBundle, (String)"View all entries filed under '{0}'", null, (Object[])new Object[]{tag.getTitlePath().replaceAll("\"", "&quot;")}));
        sb.append("\">");
        sb.append(tag.getTitle());
        sb.append("</a>");
        return sb.toString();
    }

    @Override
    public String getTagsAsHTML() {
        return this.getTagsAsHTML(null);
    }

    @Override
    public String getTagsAsHTML(ResourceBundle resourceBundle) {
        Tag[] tags;
        StringBuffer sb = new StringBuffer();
        sb.append("<ul>");
        for (Tag tag : tags = this.getTags()) {
            sb.append("<li>");
            sb.append(this.getTagAsHTML(tag, resourceBundle));
            sb.append(" (");
            sb.append(this.getTagCount(tag));
            sb.append(")");
            sb.append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    @Override
    public int getTagCount(Tag tag) {
        this.initTags();
        return this.tagCounts.containsKey(tag.getPath()) ? this.tagCounts.get(tag.getPath()) : 0;
    }

    @Override
    public String getAuthorsAsHTML() {
        return this.getAuthorsAsHTML(null);
    }

    @Override
    public String getAuthorsAsHTML(ResourceBundle resourceBundle) {
        String[] authors;
        StringBuffer sb = new StringBuffer();
        sb.append("<ul>");
        for (String author : authors = this.getAuthors()) {
            sb.append("<li>");
            sb.append(this.getAuthorAsHTML(author, resourceBundle));
            sb.append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    @Override
    public String getAuthorAsHTML(String author) {
        return this.getAuthorAsHTML(author, null);
    }

    @Override
    public String getAuthorAsHTML(String author, ResourceBundle resourceBundle) {
        String encodedAuthor = author;
        try {
            encodedAuthor = URLEncoder.encode(encodedAuthor, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<a href=\"");
        sb.append(this.getUrl());
        sb.append(new BlogSuffixImpl("author", encodedAuthor).toString());
        sb.append("\"");
        sb.append(" title=\"");
        sb.append(I18n.get((ResourceBundle)resourceBundle, (String)"View all entries by {0}", null, (Object[])new Object[]{author.replaceAll("\"", "&quot;")}));
        sb.append("\">");
        sb.append(author);
        sb.append("</a>");
        return sb.toString();
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public BlogEntry getEntry() {
        return this.entry;
    }

    @Override
    public boolean isEntry() {
        return this.entry != null;
    }

    @Override
    public boolean isArchive() {
        if (this.entry == null) {
            String p = this.resource.getPath();
            if (!(p = p.substring(0, p.lastIndexOf("/jcr:content"))).equals(this.page.getPath())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTitle() {
        return this.page.getTitle() != null ? this.page.getTitle() : "Untitled";
    }

    @Override
    public void setTitle(String title) {
        try {
            ((Node)this.page.getContentResource().adaptTo(Node.class)).setProperty("jcr:title", title);
            this.dirty = true;
        }
        catch (Exception e) {
            log.error("failed to set title", (Throwable)e);
        }
    }

    @Override
    public String getDescription() {
        return this.page.getDescription() != null ? this.page.getDescription() : "";
    }

    @Override
    public void setDescription(String desc) {
        try {
            ((Node)this.page.getContentResource().adaptTo(Node.class)).setProperty("jcr:description", desc);
            this.dirty = true;
        }
        catch (Exception e) {
            log.error("failed to set description", (Throwable)e);
        }
    }

    @Override
    public String getUrl() {
        return this.page.getPath() + ".html";
    }

    @Override
    public String getFullUrl() {
        return this.externalize(this.getUrl());
    }

    @Override
    public String getFeedUrl() {
        return this.externalize(this.page.getPath() + "/jcr:content.feed");
    }

    @Override
    public String getFeedUrl(boolean absolute) {
        if (absolute) {
            return this.externalize(this.page.getPath() + "/jcr:content.feed");
        }
        return this.page.getPath() + "/jcr:content.feed";
    }

    @Override
    public String getViewUrl(String view) {
        return this.getUrl() + "?" + "blog" + "=" + view;
    }

    @Override
    public String getAddEntryUrl(SlingHttpServletRequest request) {
        if (request == null) {
            request = this.request;
        }
        if (WCMMode.fromRequest((ServletRequest)request) == WCMMode.EDIT) {
            return this.getViewUrl("new");
        }
        String addEntryUrl = this.externalize("/collabauthor" + this.getViewUrl("new"));
        if (!addEntryUrl.startsWith("/collabauthor")) {
            return addEntryUrl;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.getEntries().size() == 0;
    }

    @Override
    public BlogEntry getPreviousEntry(BlogEntry refEntry) {
        List<BlogEntry> entries = this.getEntries();
        try {
            for (int i = 0; i < entries.size(); ++i) {
                BlogEntry entry = entries.get(i);
                if (!entry.getUrl().equals(refEntry.getUrl())) continue;
                return entries.get(i - 1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public BlogEntry getNextEntry(BlogEntry refEntry) {
        List<BlogEntry> entries = this.getEntries();
        try {
            for (int i = 0; i < entries.size(); ++i) {
                BlogEntry entry = entries.get(i);
                if (!entry.getUrl().equals(refEntry.getUrl())) continue;
                return entries.get(i + 1);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public BlogArchive getArchive(int max, DateFormat dateFormat) {
        if (this.archive == null) {
            this.archive = new BlogArchive(this, max, dateFormat);
        }
        return this.archive;
    }

    @Override
    public String getArchiveAsHTML(int max, DateFormat dateFormat) {
        return this.getArchiveAsHTML(max, dateFormat, null);
    }

    @Override
    public String getArchiveAsHTML(int max, DateFormat dateFormat, ResourceBundle resourceBundle) {
        List<BlogArchive.Period> periods = this.getArchive(max, dateFormat).getPeriods();
        StringBuffer sb = new StringBuffer();
        sb.append("<ul>");
        for (BlogArchive.Period period : periods) {
            sb.append("<li>");
            sb.append(this.getArchiveEntryAsHTML(period, resourceBundle));
            sb.append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    @Override
    public boolean isModified() {
        return this.dirty;
    }

    @Override
    public void save() throws BlogException {
        if (this.dirty) {
            try {
                this.manager.save();
                this.dirty = false;
            }
            catch (CollabException ce) {
                throw new BlogException(ce);
            }
        }
    }

    private void initEntries() {
        if (this.entries == null) {
            this.entries = this.collectEntries(this.page, null);
            Collections.sort(this.entries, new BlogEntryDateComparator());
        }
    }

    private void initTags() {
        if (this.tags == null) {
            this.tags = new HashMap<String, Tag>();
            this.tagCounts = new HashMap<String, Integer>();
            for (BlogEntry entry : this.getEntries()) {
                for (Tag tag : entry.getTags()) {
                    String key = tag.getPath();
                    boolean newTag = !this.tags.containsKey(key);
                    int count = 1 + (newTag ? 0 : this.tagCounts.get(key));
                    if (newTag) {
                        this.tags.put(key, tag);
                    }
                    this.tagCounts.put(key, count);
                }
            }
        }
    }

    private List<BlogEntry> collectEntries(Page startPage, List<BlogEntry> entries) {
        if (entries == null) {
            entries = new ArrayList<BlogEntry>();
        }
        try {
            Iterator children = startPage.listChildren();
            while (children.hasNext()) {
                Page child = (Page)children.next();
                if (child.hasContent() && child.getContentResource("par/entry") != null) {
                    entries.add(new BlogEntryImpl(this.request, child, this.manager));
                    continue;
                }
                entries = this.collectEntries(child, entries);
            }
        }
        catch (Exception e) {
            log.info("unable to collect entries:", (Throwable)e);
        }
        return entries;
    }

    private String getArchiveEntryAsHTML(BlogArchive.Period period, ResourceBundle resourceBundle) {
        StringBuffer sb = new StringBuffer();
        sb.append("<a href=\"");
        sb.append(period.getUrl());
        sb.append("\" title=\"");
        sb.append(I18n.get((ResourceBundle)resourceBundle, (String)"View all entries from {0}", null, (Object[])new Object[]{period.getTitle()}));
        sb.append("\">");
        sb.append(period.getTitle());
        sb.append("</a>");
        return sb.toString();
    }

    private BlogEntry addEntry(String parentPath, String title, String text, boolean isPage) throws Exception {
        String name;
        ValueMap props = this.page.getProperties();
        Resource parentRes = this.resource.getResourceResolver().getResource(parentPath);
        if (parentRes == null || parentRes.adaptTo(Node.class) == null) {
            Resource grandParentRes;
            String parentTitle = Text.getName((String)parentPath);
            if (isPage) {
                parentTitle = parentTitle.substring(0, 1).toUpperCase() + parentTitle.substring(1);
            }
            String grandParentPath = Text.getRelativeParent((String)parentPath, (int)1);
            String grandParentTitle = Text.getName((String)grandParentPath);
            if (isPage) {
                grandParentTitle = grandParentTitle.substring(0, 1).toUpperCase() + grandParentTitle.substring(1);
            }
            if ((grandParentRes = this.resource.getResourceResolver().getResource(grandParentPath)) == null || grandParentRes.adaptTo(Node.class) == null) {
                Page grandParentPage = this.manager.createPage(grandParentPath, null, (String)props.get("sling:resourceType", (Object)"collab/blog/components/page"), grandParentTitle);
                if (!isPage) {
                    ((Node)grandParentPage.getContentResource().adaptTo(Node.class)).setProperty("blogarchive", Text.getName((String)grandParentPath));
                }
            }
            Page parentPage = this.manager.createPage(parentPath, null, (String)props.get("sling:resourceType", (Object)"collab/blog/components/page"), parentTitle);
            ((Node)parentPage.getContentResource().adaptTo(Node.class)).setProperty("blogarchive", grandParentTitle + '/' + parentTitle);
        }
        if ((name = title).length() > 20) {
            name = name.substring(0, 20);
        }
        String pageTemplate = (String)props.get("cq:template", (Object)"/libs/collab/blog/templates/page");
        String pageResourceType = (String)props.get("sling:resourceType", (Object)"collab/blog/components/page");
        String textResourceType = this.findTextComponent(pageResourceType);
        Page entryPage = this.manager.createPage(parentPath, JcrUtil.createValidName((String)name), pageTemplate, pageResourceType, title);
        Node resourcePageNode = (Node)entryPage.getContentResource().adaptTo(Node.class);
        if (resourcePageNode.hasProperty("cq:designPath")) {
            resourcePageNode.getProperty("cq:designPath").remove();
            this.save();
        }
        String textPath = entryPage.getPath() + "/" + "jcr:content" + "/" + "par/entry";
        Node parSys = this.manager.createNode(Text.getRelativeParent((String)textPath, (int)1), "nt:unstructured");
        parSys.setProperty("sling:resourceType", "foundation/components/parsys");
        Node textNode = this.manager.createNode(textPath, "nt:unstructured");
        textNode.setProperty("sling:resourceType", textResourceType);
        if (!isPage) {
            String commentsPath = entryPage.getPath() + "/" + "jcr:content" + "/" + "alt/comments";
            String trackbacksPath = entryPage.getPath() + "/" + "jcr:content" + "/" + "alt/trackback";
            Node altParsys = this.manager.createNode(Text.getRelativeParent((String)commentsPath, (int)1), "nt:unstructured");
            altParsys.setProperty("sling:resourceType", "foundation/components/parsys");
            Node commentsNode = this.manager.createNode(commentsPath, "nt:unstructured");
            commentsNode.setProperty("sling:resourceType", "collab/commons/components/comments");
            Node trackbacksNode = this.manager.createNode(trackbacksPath, "nt:unstructured");
            trackbacksNode.setProperty("sling:resourceType", "collab/blog/components/trackback");
        }
        BlogEntry entry = this.manager.getBlogEntry(this.request, entryPage.getPath());
        entry.setTitle(title);
        entry.setText(text);
        this.dirty = true;
        return entry;
    }

    private String findTextComponent(String siblingResourceType) {
        String path = Text.getRelativeParent((String)siblingResourceType, (int)1) + "/entrytext";
        Resource component = this.resource.getResourceResolver().getResource(path);
        if (component != null) {
            try {
                return ((Component)component.adaptTo(Component.class)).getResourceType();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return "collab/blog/components/entrytext";
    }

    protected static Page findPage(Resource res) {
        Page page = null;
        ResourceResolver rr = res.getResourceResolver();
        try {
            while (res.getPath().lastIndexOf("/") > 0) {
                page = (Page)res.adaptTo(Page.class);
                if (page != null && "".equals(page.getProperties().get("blogarchive", (Object)""))) {
                    return page;
                }
                res = rr.getResource(res.getPath().substring(0, res.getPath().lastIndexOf("/")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return page;
    }
}

