/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.blog.impl.importer;

import com.day.cq.collab.blog.Blog;
import com.day.cq.collab.blog.BlogEntry;
import com.day.cq.collab.blog.BlogException;
import com.day.cq.collab.blog.impl.importer.ImportedBlogEntryFilter;
import com.day.cq.collab.blog.impl.importer.RssFetcherListener;
import com.day.cq.polling.importer.ImportException;
import com.day.cq.polling.importer.Importer;
import com.day.cq.tagging.InvalidTagFormatException;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.HttpClientFeedFetcher;
import com.sun.syndication.fetcher.impl.LinkedHashMapFeedInfoCache;
import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(metatype=true, enabled=false)
@Service
@Properties(value={@Property(name="service.description", value={"RSS Importer (based on Rome)"}), @Property(name="importer.scheme", value={"rss", "atom"})})
public class FeedImporter
implements Importer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(String scheme, String dataSource, Resource target) throws ImportException {
        Blog blog = (Blog)target.adaptTo(Blog.class);
        if (blog == null) {
            throw new ImportException("Import target '" + target + "' must be a Blog");
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            this.fetchFeed(blog, dataSource);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void fetchFeed(Blog blog, String dataSource) {
        this.log.info("fetching feed '{}'", (Object)dataSource);
        try {
            FeedFetcherCache feedInfoCache = LinkedHashMapFeedInfoCache.getInstance();
            HttpClientFeedFetcher fetcher = new HttpClientFeedFetcher(feedInfoCache);
            RssFetcherListener listener = new RssFetcherListener();
            fetcher.addFetcherEventListener(listener);
            URL url = new URL(dataSource);
            String userInfo = url.getUserInfo();
            this.log.debug("feed URL's userinfo=" + url.getUserInfo());
            if (userInfo != null && userInfo.indexOf(58) >= 0) {
                String[] split = userInfo.split(":");
                final UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(split[0], split[1]);
                fetcher.setCredentialSupplier(new HttpClientFeedFetcher.CredentialSupplier(){

                    public Credentials getCredentials(String realm, String host) {
                        return credentials;
                    }
                });
            }
            SyndFeed feed = fetcher.retrieveFeed(url);
            if (listener.hasFeedChanged()) {
                this.log.info("feed fetched successfully: title=" + feed.getTitle() + ", entries=" + feed.getEntries().size());
                ArrayList feedEntries = new ArrayList(feed.getEntries());
                Collections.sort(feedEntries, new Comparator<Object>(){

                    @Override
                    public int compare(Object left, Object right) {
                        Date rightDate;
                        SyndEntry leftEntry = (SyndEntry)left;
                        SyndEntry rightEntry = (SyndEntry)right;
                        Date leftDate = leftEntry.getUpdatedDate();
                        if (leftDate == null) {
                            leftDate = leftEntry.getPublishedDate();
                        }
                        if ((rightDate = rightEntry.getUpdatedDate()) == null) {
                            rightDate = rightEntry.getPublishedDate();
                        }
                        if (leftDate == null || rightDate == null) {
                            return 0;
                        }
                        return leftDate.compareTo(rightDate);
                    }
                });
                Iterator entries = feedEntries.iterator();
                while (entries.hasNext()) {
                    this.createOrUpdateEntry(blog, (SyndEntry)entries.next());
                }
            } else {
                this.log.info("feed did not change");
            }
        }
        catch (MalformedURLException e) {
            this.log.warn("Could not fetch feed '" + dataSource + "'. " + e.getMessage());
        }
        catch (FeedException e) {
            this.log.warn("Could not fetch feed '" + dataSource + "'. " + e.getMessage());
        }
        catch (FetcherException e) {
            this.log.warn("Could not fetch feed '" + dataSource + "'. " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.log.error("Could not fetch feed '" + dataSource + "'", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Could not fetch feed '" + dataSource + "'", (Throwable)e);
        }
    }

    private void createOrUpdateEntry(Blog blog, SyndEntry entry) {
        String uri = this.getUri(entry);
        Date date = this.getDate(entry);
        BlogEntry blogEntry = this.getBlogEntry(blog, uri);
        if (blogEntry != null) {
            if (date.getTime() <= blogEntry.getDate().getTime()) {
                this.log.debug("entry stored already and up-to-date: '{}'", (Object)uri);
                return;
            }
            this.log.info("entry stored, but updated in feed: '{}'", (Object)uri);
        }
        String title = entry.getTitle();
        String text = this.getText(entry);
        String author = entry.getAuthor();
        Tag[] tags = this.getTags(entry, blog.getResource().getResourceResolver());
        if (blogEntry == null) {
            try {
                blogEntry = blog.addEntry(title, text, date);
                blogEntry.setId(uri);
                blogEntry.setAuthor(author);
                blogEntry.setTags(tags);
            }
            catch (BlogException be) {
                this.log.error("failed to add entry", (Throwable)((Object)be));
                return;
            }
        } else {
            blogEntry.setTitle(title);
            blogEntry.setText(text);
            blogEntry.setAuthor(author);
            blogEntry.setTags(tags);
        }
        try {
            blogEntry.save();
        }
        catch (BlogException be) {
            this.log.error("createOrUpdateEntry: Failed saving blog entry " + uri, (Throwable)((Object)be));
        }
    }

    private BlogEntry getBlogEntry(Blog blog, String uri) {
        ImportedBlogEntryFilter filter = new ImportedBlogEntryFilter(uri);
        List<BlogEntry> entries = blog.getEntries(filter);
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        return entries.get(0);
    }

    private String getUri(SyndEntry syndEntry) {
        String uri = syndEntry.getUri();
        if (uri == null) {
            uri = syndEntry.getLink();
        }
        return uri;
    }

    private Date getDate(SyndEntry syndEntry) {
        Date date = syndEntry.getPublishedDate();
        if (date == null && (date = syndEntry.getUpdatedDate()) == null) {
            date = new Date();
        }
        return date;
    }

    private String getText(SyndEntry syndEntry) {
        String text = null;
        if (!syndEntry.getContents().isEmpty()) {
            text = ((SyndContent)syndEntry.getContents().get(0)).getValue();
        }
        if (text == null) {
            text = syndEntry.getDescription() != null ? syndEntry.getDescription().getValue() : "";
        }
        return text;
    }

    private Tag[] getTags(SyndEntry syndEntry, ResourceResolver resolver) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        TagManager tm = (TagManager)resolver.adaptTo(TagManager.class);
        if (tm != null) {
            Iterator categories = syndEntry.getCategories().iterator();
            while (categories.hasNext()) {
                String tagName = ((SyndCategory)categories.next()).getName();
                if (tagName == null) continue;
                Tag tag = tm.resolveByTitle(tagName = FeedImporter.escapeTagTitlePath(tagName));
                if (tag == null) {
                    try {
                        tag = tm.createTagByTitle(tagName);
                    }
                    catch (InvalidTagFormatException itfe) {
                        this.log.info("getTags: Cannot create Tag for {}", (Object)tagName);
                        continue;
                    }
                }
                if (tag != null) {
                    tagList.add(tag);
                    continue;
                }
                this.log.debug("getTags: Ignoring tag '{}'; could resolve or create a Tag", (Object)tagName);
            }
        }
        return tagList.toArray(new Tag[tagList.size()]);
    }

    private static String escapeTagTitlePath(String titlePath) {
        if (titlePath == null) {
            return null;
        }
        return titlePath.replaceAll("/", " ").replaceAll(":", " ");
    }
}

