/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.blog.impl.servlets;

import com.day.cq.collab.blog.Blog;
import com.day.cq.collab.blog.BlogEntry;
import com.day.cq.collab.blog.BlogManager;
import com.day.cq.collab.blog.DraftEntryFilter;
import com.day.cq.collab.commons.Comment;
import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.PageInfoProvider;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(metatype=false)
@Service(value={Servlet.class, PageInfoProvider.class})
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.selectors", value={"bloginfo"}), @Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class BlogInfoServlet
extends SlingSafeMethodsServlet
implements PageInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(BlogInfoServlet.class);
    public static final String TIDY = "tidy";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        try {
            this.getBlogInfo(request.getResourceResolver(), request.getResource()).write((Writer)response.getWriter());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void updatePageInfo(SlingHttpServletRequest request, JSONObject info, Resource resource) throws JSONException {
        info.put("blog", (Object)this.getBlogInfo(resource.getResourceResolver(), resource));
    }

    private JSONObject getBlogInfo(ResourceResolver resolver, Resource resource) throws JSONException {
        JSONObject blogInfo = new JSONObject();
        BlogManager blogMgr = (BlogManager)resolver.adaptTo(BlogManager.class);
        Blog blog = blogMgr.getBlog(resource.getPath());
        if (blog != null) {
            List<BlogEntry> entries = blog.getEntries();
            ArrayList<Comment> comments = new ArrayList<Comment>();
            if (blog.isEntry()) {
                comments.addAll(blog.getEntry().getComments());
            } else {
                for (BlogEntry entry : entries) {
                    comments.addAll(entry.getComments());
                }
            }
            List<BlogEntry> drafts = blog.getEntries(new DraftEntryFilter(true));
            int spam = 0;
            for (Comment comment : comments) {
                if (!comment.isSpam()) continue;
                ++spam;
            }
            blogInfo.put("title", (Object)blog.getTitle());
            blogInfo.put("description", (Object)blog.getDescription());
            blogInfo.put("path", (Object)blog.getPage().getPath());
            blogInfo.put("tags", (Object)this.getTagInfo(blog));
            blogInfo.put("authors", (Object)this.getAuthorInfo(blog));
            blogInfo.put("entries", entries.size());
            blogInfo.put("drafts", drafts.size());
            blogInfo.put("pages", blog.getPages().size());
            blogInfo.put("comments", comments.size());
            blogInfo.put("spam", spam);
            if (blog.isEntry()) {
                JSONObject entryInfo = new JSONObject();
                entryInfo.put("draft", blog.getEntry().isDraft());
                blogInfo.put("entry", (Object)entryInfo);
            }
        }
        return blogInfo;
    }

    private JSONArray getTagInfo(Blog blog) {
        JSONArray info = new JSONArray();
        for (Tag tag : blog.getTags()) {
            info.put((Object)tag.getPath());
        }
        return info;
    }

    private JSONArray getAuthorInfo(Blog blog) {
        JSONArray info = new JSONArray();
        for (String author : blog.getAuthors()) {
            info.put((Object)author);
        }
        return info;
    }
}

