/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.blog.impl.servlets;

import com.day.cq.collab.blog.BlogEntry;
import com.day.cq.collab.blog.BlogException;
import com.day.cq.collab.blog.impl.BlogImpl;
import com.day.cq.security.Authorizable;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(metatype=true, label="%createblogentryservlet.name", description="%createblogentryservlet.description")
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.selectors", value={"createblogentry"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="reverseReplicate", boolValue={true})})
public class CreateBlogEntryServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(CreateBlogEntryServlet.class);
    private static final String PARAM_TITLE = "title";
    private static final String PARAM_TEXT = "text";
    private static final String PARAM_TAGS = "tags";
    private static final String PARAM_DISPLAYIN = "displayIn";
    private static final String DISPLAYIN_TIMELINE = "timeline";
    private static final String REQ_ATTR_REDIRECT = "cq.form.redirect";
    static final String PROPERTY_REVERSE_REPLICATE = "reverseReplicate";
    static final boolean DEFAULT_REVERSE_REPLICATE = true;
    private boolean reverseReplicate;
    private static final char PATCH_ADD = '+';
    private static final char PATCH_REMOVE = '-';

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String title;
        String author;
        BlogImpl blog = new BlogImpl(request, request.getResource());
        if (blog == null) {
            throw new BlogException("target '" + request.getResource().getPath() + "' must be a blog page");
        }
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        Authorizable auth = (Authorizable)request.getResourceResolver().adaptTo(Authorizable.class);
        String string = author = auth == null ? null : auth.getName();
        if (author == null) {
            author = session.getUserID();
        }
        if ((title = request.getParameter(PARAM_TITLE)) == null || "".equals(title)) {
            log.error("title parameter missing or empty");
            response.sendRedirect(request.getContextPath() + blog.getViewUrl("new"));
            return;
        }
        String text = request.getParameter(PARAM_TEXT);
        if (text == null) {
            text = "";
        }
        String[] tags = request.getParameterValues(PARAM_TAGS);
        String displayIn = request.getParameter(PARAM_DISPLAYIN);
        boolean timeline = displayIn == null || displayIn.equals(DISPLAYIN_TIMELINE);
        try {
            Node entryNode;
            BlogEntry entry = timeline ? blog.addEntry(title, text, new Date()) : blog.addPage(title, text);
            entry.setAuthor(author);
            if (this.reverseReplicate) {
                ((Node)entry.getPage().getContentResource().adaptTo(Node.class)).setProperty("cq:distribute", true);
            }
            entry.save();
            if (tags != null && tags.length > 0 && (tags = this.patch(entryNode = (Node)entry.getContentResource().adaptTo(Node.class), "cq:tags", tags)) != null && tags.length > 0) {
                ArrayList<Tag> tagList = new ArrayList<Tag>();
                TagManager tm = (TagManager)request.getResource().getResourceResolver().adaptTo(TagManager.class);
                for (String t : tags) {
                    Tag tag = tm.resolve(t);
                    if (tag == null) continue;
                    tagList.add(tag);
                }
                entry.setTags(tagList.toArray(new Tag[tagList.size()]));
            }
            log.info("created new blog entry: " + entry.getPage().getPath());
            String url = request.getContextPath() + entry.getUrl();
            String redirect = (String)request.getAttribute(REQ_ATTR_REDIRECT);
            if (StringUtils.isNotBlank((String)redirect)) {
                url = redirect;
            } else if (request.getAttribute("selector") != null) {
                url = url.replace(".html", request.getAttribute("selector").toString() + ".html");
            }
            response.sendRedirect(url);
        }
        catch (Exception e) {
            log.error("failed to save blog entry", (Throwable)e);
            response.sendRedirect(request.getContextPath() + blog.getViewUrl("new"));
        }
    }

    protected void activate(ComponentContext context) throws Exception {
        this.reverseReplicate = OsgiUtil.toBoolean(context.getProperties().get(PROPERTY_REVERSE_REPLICATE), (boolean)true);
    }

    protected void deactivate(ComponentContext context) {
    }

    private String[] patch(Node parent, String name, String[] values) throws RepositoryException {
        ArrayList<String> oldValues = new ArrayList<String>();
        if (parent.hasProperty(name)) {
            javax.jcr.Property p = parent.getProperty(name);
            if (!p.getDefinition().isMultiple()) {
                return null;
            }
            for (String string : p.getValues()) {
                oldValues.add(string.getString());
            }
        }
        boolean modified = false;
        for (String string : values) {
            if (string == null || string.length() <= 0) continue;
            char op = string.charAt(0);
            String val = string.substring(1);
            if (op == '+') {
                if (oldValues.contains(val)) continue;
                oldValues.add(val);
                modified = true;
                continue;
            }
            if (op != '-') continue;
            while (oldValues.remove(val)) {
                modified = true;
            }
        }
        if (modified) {
            return oldValues.toArray(new String[oldValues.size()]);
        }
        return null;
    }
}

