/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.blog.search.impl;

import com.day.cq.collab.blog.search.BlogSearchPingService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Component(label="Day CQ Social Collaboration Blog Search Engine Ping", description="Blog Search Ping configuration")
@Service
@Property(name="service.description", value={"Blog Search Engine Ping"})
public class BlogSearchPingServiceImpl
implements BlogSearchPingService {
    private Log logger = LogFactory.getLog(BlogSearchPingServiceImpl.class);
    private static final String GOOGLE_RPC_ENDPOINT = "http://blogsearch.google.com/ping/RPC2";
    private static final String GOOGLE_RPC_METHOD_NAME = "weblogUpdates.extendedPing";
    private static final String TECHNORATI_RPC_ENDPOINT = "http://rpc.technorati.com/rpc/ping";
    private static final String TECHNORATI_RPC_METHOD_NAME = "weblogUpdates.ping";
    private static final String BLOGLINES_RPC_ENDPOINT = "http://rpc.weblogs.com/RPC2";
    private static final String BLOGLINES_RPC_METHOD_NAME = "weblogUpdates.ping";
    private static final String PINGOMATIC_RPC_ENDPOINT = "http://rpc.pingomatic.com/";
    private static final String PINGOMATIC_RPC_METHOD_NAME = "weblogUpdates.ping";
    @Property(boolValue={true})
    public static final String PING_GOOGLE = "blogsearch.service.ping.google";
    @Property(boolValue={true})
    public static final String PING_TECHNORATI = "blogsearch.service.ping.technorati";
    @Property(boolValue={false})
    public static final String PING_BLOGLINES = "blogsearch.service.ping.bloglines";
    @Property(boolValue={true})
    public static final String PING_PINGOMATIC = "blogsearch.service.ping.pingomatic";
    private boolean pingGoogle = true;
    private boolean pingTechnorati = true;
    private boolean pingBloglines = false;
    private boolean pingPingomatic = true;

    public BlogSearchPingServiceImpl() {
    }

    BlogSearchPingServiceImpl(BundleContext bundleContext, Dictionary<String, Object> configuration) {
        this.setup(bundleContext, configuration);
    }

    void setup(BundleContext bundleContext, Dictionary<String, Object> configuration) {
        Object pingomaticProvider;
        Object bloglinesProvider;
        Object technoratiProvider;
        Object googleProvider = configuration.get(PING_GOOGLE);
        if (googleProvider != null) {
            this.pingGoogle = (Boolean)googleProvider;
        }
        if ((technoratiProvider = configuration.get(PING_TECHNORATI)) != null) {
            this.pingTechnorati = (Boolean)technoratiProvider;
        }
        if ((bloglinesProvider = configuration.get(PING_BLOGLINES)) != null) {
            this.pingBloglines = (Boolean)bloglinesProvider;
        }
        if ((pingomaticProvider = configuration.get(PING_PINGOMATIC)) != null) {
            this.pingPingomatic = (Boolean)pingomaticProvider;
        }
    }

    void shutdown() {
    }

    protected void activate(ComponentContext context) {
        this.setup(context.getBundleContext(), context.getProperties());
    }

    protected void deactivate(ComponentContext context) {
        this.shutdown();
    }

    @Override
    public boolean ping(String nameOfSite, String urlOfSite, String urlOfPage, String urlOfSiteFeed) {
        boolean cumulatedReturnValue = true;
        if (this.pingGoogle) {
            this.logger.debug((Object)"pinging Google blog search");
            try {
                cumulatedReturnValue = cumulatedReturnValue && this.pingGoogleBlogSearch(nameOfSite, urlOfSite, urlOfPage, urlOfSiteFeed);
            }
            catch (XmlRpcException e) {
                this.logger.error((Object)"Error pinging Google Blog Search", (Throwable)e);
            }
        } else {
            this.logger.debug((Object)"not pinging Google blog search");
        }
        if (this.pingTechnorati) {
            this.logger.debug((Object)"pinging Technorati");
            try {
                cumulatedReturnValue = cumulatedReturnValue && this.pingTechnorati(nameOfSite, urlOfSite);
            }
            catch (XmlRpcException e) {
                this.logger.error((Object)"Error pinging Technorati", (Throwable)e);
            }
        } else {
            this.logger.debug((Object)"not pinging Technorati");
        }
        if (this.pingBloglines) {
            this.logger.debug((Object)"pinging Bloglines");
            try {
                cumulatedReturnValue = cumulatedReturnValue && this.pingBloglines(nameOfSite, urlOfSite);
            }
            catch (XmlRpcException e) {
                this.logger.error((Object)"Error pinging Bloglines", (Throwable)e);
            }
        } else {
            this.logger.debug((Object)"not pinging Bloglines");
        }
        if (this.pingPingomatic) {
            this.logger.debug((Object)"pinging Pingomatic");
            try {
                cumulatedReturnValue = cumulatedReturnValue && this.pingPingomatic(nameOfSite, urlOfSite);
            }
            catch (XmlRpcException e) {
                this.logger.error((Object)"Error pinging Pingomatic", (Throwable)e);
            }
        } else {
            this.logger.debug((Object)"not pinging Pingomatic");
        }
        return cumulatedReturnValue;
    }

    protected boolean pingGoogleBlogSearch(String nameOfSite, String urlOfSite, String urlOfPage, String urlOfSiteFeed) throws XmlRpcException {
        return this.genericXmlRpcPing(GOOGLE_RPC_ENDPOINT, GOOGLE_RPC_METHOD_NAME, "Google Blog Search", nameOfSite, urlOfSite, urlOfPage, urlOfSiteFeed);
    }

    protected boolean pingTechnorati(String nameOfSite, String urlOfSite) throws XmlRpcException {
        return this.genericXmlRpcPing(TECHNORATI_RPC_ENDPOINT, "weblogUpdates.ping", "Technorati", nameOfSite, urlOfSite, null, null);
    }

    protected boolean pingBloglines(String nameOfSite, String urlOfSite) throws XmlRpcException {
        return this.genericXmlRpcPing(BLOGLINES_RPC_ENDPOINT, "weblogUpdates.ping", "Bloglines", nameOfSite, urlOfSite, null, null);
    }

    protected boolean pingPingomatic(String nameOfSite, String urlOfSite) throws XmlRpcException {
        return this.genericXmlRpcPing(PINGOMATIC_RPC_ENDPOINT, "weblogUpdates.ping", "Pingomatic", nameOfSite, urlOfSite, null, null);
    }

    private boolean genericXmlRpcPing(String rpcEndpointOfService, String rpcMethodOfService, String verboseNameOfService, String nameOfSite, String urlOfSite, String urlOfPage, String urlOfSiteFeed) throws XmlRpcException {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        try {
            config.setServerURL(new URL(rpcEndpointOfService));
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)("Bad XMLRPC URL: " + rpcEndpointOfService), (Throwable)e);
            return false;
        }
        XmlRpcClient client = new XmlRpcClient();
        Object[] params = null;
        params = urlOfPage != null && urlOfSiteFeed != null ? new Object[]{nameOfSite, urlOfSite, urlOfPage, urlOfSiteFeed} : new Object[]{nameOfSite, urlOfSite};
        HashMap result = (HashMap)client.execute((XmlRpcClientConfig)config, rpcMethodOfService, params);
        boolean error = false;
        if (result.containsKey("flerror")) {
            error = (Boolean)result.get("flerror");
        }
        String message = null;
        if (result.containsKey("message")) {
            message = (String)result.get("message");
        }
        if (error) {
            this.logger.error((Object)("Error pinging " + verboseNameOfService + ": " + message));
            return false;
        }
        this.logger.info((Object)("Pinged " + verboseNameOfService));
        return true;
    }
}

