/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.blog.search.process;

import com.day.cq.collab.blog.Blog;
import com.day.cq.collab.blog.BlogEntry;
import com.day.cq.collab.blog.BlogManager;
import com.day.cq.collab.blog.search.BlogSearchPingService;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(metatype=false)
@Service(value={WorkflowProcess.class})
@Property(name="process.label", value={"Blog Search Ping"})
public class BlogSearchPingProcess
implements WorkflowProcess {
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Reference
    private BlogSearchPingService blogSearchPingService;
    @Reference
    private JcrResourceResolverFactory jcrResourceResolverFactory;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        Session session = workflowSession.getSession();
        WorkflowData data = workItem.getWorkflowData();
        String path = null;
        String type = data.getPayloadType();
        try {
            String payloadData;
            if (type.equals(TYPE_JCR_PATH) && data.getPayload() != null && session.itemExists(payloadData = (String)data.getPayload())) {
                path = payloadData;
            }
            if (path != null) {
                Node blogPost = (Node)session.getItem(path);
                ResourceResolver resourceResolver = this.jcrResourceResolverFactory.getResourceResolver(session);
                Resource resource = resourceResolver.getResource(path);
                BlogManager blogManager = (BlogManager)resource.getResourceResolver().adaptTo(BlogManager.class);
                Blog blog = blogManager.getBlog(path);
                if (blog != null && blog.isEntry()) {
                    BlogEntry entry = blog.getEntry();
                    this.blogSearchPingService.ping(blog.getTitle(), blog.getFullUrl(), entry.getFullUrl(), blog.getFeedUrl(true));
                    this.logger.info("Submitted this item to blog search engines: " + workItem.toString());
                } else {
                    this.logger.warn("Cannot submit this item to blog search engines: " + workItem.toString());
                }
            } else {
                this.logger.warn("Cannot submit this item to blog search engines: " + workItem.toString());
            }
        }
        catch (RepositoryException e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    protected void bindBlogSearchPingService(BlogSearchPingService blogSearchPingService) {
        this.blogSearchPingService = blogSearchPingService;
    }

    protected void unbindBlogSearchPingService(BlogSearchPingService blogSearchPingService) {
        if (this.blogSearchPingService == blogSearchPingService) {
            this.blogSearchPingService = null;
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }
}

