/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.collab.blog.trackback;

import com.day.cq.collab.blog.BlogEntry;
import com.day.cq.collab.blog.BlogException;
import com.day.cq.xss.XSSProtectionException;
import com.day.cq.xss.XSSProtectionService;
import com.day.text.Text;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"Trackback Servlet"}), @Property(name="sling.servlet.resourceTypes", value={"cq/Page"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="sling.servlet.selectors", value={"trackback"}), @Property(name="reverseReplicate", boolValue={true})})
public class TrackbackServlet
extends SlingAllMethodsServlet {
    @Reference
    private XSSProtectionService xssProtectionService;
    @Reference
    protected JcrResourceResolverFactory jcrResourceResolverFactory;
    @Reference
    protected SlingRepository repository;
    static final String PROPERTY_REVERSE_REPLICATE = "reverseReplicate";
    static final boolean DEFAULT_REVERSE_REPLICATE = true;
    private boolean reverseReplicate;
    protected Session session;
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        if (!request.getContentType().equalsIgnoreCase("application/x-www-form-urlencoded")) {
            response.getOutputStream().print(this.error("content type must be application/x-www-form-urlencoded but is " + request.getContentType()));
            response.getOutputStream().flush();
            return;
        }
        if (request.getParameter("url") == null) {
            response.getOutputStream().print(this.error("client must send a url"));
            response.getOutputStream().flush();
            return;
        }
        try {
            this.startSession(null);
            this.createTrackbackNode(request);
            response.getOutputStream().print(this.success());
            response.getOutputStream().flush();
        }
        catch (BlogException be) {
            response.getOutputStream().print(this.error("unspecified error"));
            this.log.error(be.getMessage());
            response.getOutputStream().flush();
        }
        catch (XSSProtectionException e) {
            response.getOutputStream().print(this.error("xssprotection error"));
            this.log.error(e.getMessage());
        }
        finally {
            this.endSession();
        }
    }

    private void createTrackbackNode(SlingHttpServletRequest request) throws BlogException, XSSProtectionException {
        String checkPath;
        Resource resource = this.getResourceResolver().getResource(request.getResource().getPath());
        BlogEntry blogEntry = (BlogEntry)resource.adaptTo(BlogEntry.class);
        Session checkSession = (Session)request.getResourceResolver().adaptTo(Session.class);
        if (!this.hasPermission(checkSession, checkPath = Text.getAbsoluteParent((String)"/content/usergenerated", (int)1))) {
            return;
        }
        String title = "";
        if (request.getParameter("title") != null) {
            title = request.getParameter("title");
        }
        String excerpt = "";
        if (request.getParameter("excerpt") != null) {
            excerpt = request.getParameter("excerpt");
        }
        String url = "";
        if (request.getParameter("url") != null) {
            url = request.getParameter("url");
        }
        String blogName = "";
        if (request.getParameter("blog_name") != null) {
            blogName = request.getParameter("blog_name");
        }
        blogEntry.addTrackback(title, excerpt, url, blogName, request.getRemoteAddr());
        blogEntry.save();
    }

    private String success() {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?><response><error>0</error></response>";
    }

    private String error(String message) {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?><response><error>1</error><message>" + message + "</message></response>";
    }

    protected void startSession(Resource resource) {
        if (resource != null) {
            this.session = (Session)resource.getResourceResolver().adaptTo(Session.class);
        } else {
            try {
                this.session = this.repository.loginAdministrative(null);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
    }

    protected void endSession() {
        if (this.session != null) {
            try {
                this.session.logout();
            }
            catch (Exception e) {
                return;
            }
            this.session = null;
        }
    }

    protected boolean hasPermission(Session session, String path) {
        if (session == null) {
            this.log.error("session must not be null");
            return false;
        }
        try {
            this.log.debug("check if user '" + session.getUserID() + "' is allowed to add nodes under " + path);
            session.checkPermission(path + "/_add_node_" + System.currentTimeMillis(), "add_node");
            return true;
        }
        catch (Exception e) {
            this.log.error("user '" + session.getUserID() + "' not allowed to add nodes under " + path, (Throwable)e);
            return false;
        }
    }

    protected ResourceResolver getResourceResolver() {
        return this.jcrResourceResolverFactory.getResourceResolver(this.session);
    }

    protected void deactivate(ComponentContext context) {
        this.endSession();
    }

    protected void bindXssProtectionService(XSSProtectionService xSSProtectionService) {
        this.xssProtectionService = xSSProtectionService;
    }

    protected void unbindXssProtectionService(XSSProtectionService xSSProtectionService) {
        if (this.xssProtectionService == xSSProtectionService) {
            this.xssProtectionService = null;
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

